<?php
/**
 * Admin Login Page
 * Aegean Dominance Admin Panel
 */

session_start();
require_once __DIR__ . '/../config/config.php';

$auth = new Auth();

// Zaten giriş yapmışsa dashboard'a yönlendir
if ($auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

// Form gönderimi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF kontrolü
    if (!isset($_POST['csrf_token']) || !$auth->validateCsrf($_POST['csrf_token'])) {
        $error = 'Güvenlik doğrulaması başarısız. Lütfen tekrar deneyin.';
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        $remember = isset($_POST['remember']);
        
        $result = $auth->login($username, $password, $remember);
        
        if ($result['success']) {
            header('Location: index.php');
            exit;
        } else {
            $error = $result['error'] ?? 'Giriş başarısız.';
        }
    }
}

$csrfToken = $auth->generateCsrf();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Admin Girişi | İzmir Tenteci</title>
    
    <!-- TailwindCSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        dark: {
                            900: '#0a0a0a',
                            800: '#121212',
                            700: '#1a1a1a',
                            600: '#222222'
                        },
                        gold: {
                            DEFAULT: '#D4AF37',
                            light: '#E6C65C',
                            dark: '#B8942F'
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <style>
        body {
            background: radial-gradient(ellipse at top, #1a1a1a 0%, #0a0a0a 50%, #000 100%);
            min-height: 100vh;
        }
        .glass-card {
            background: rgba(26, 26, 26, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(212, 175, 55, 0.2);
        }
        .gold-gradient {
            background: linear-gradient(135deg, #D4AF37 0%, #E6C65C 50%, #D4AF37 100%);
        }
        .input-style {
            background: rgba(10, 10, 10, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        .input-style:focus {
            border-color: #D4AF37;
            box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
        }
    </style>
</head>
<body class="flex items-center justify-center p-4">
    
    <!-- Background Pattern -->
    <div class="fixed inset-0 opacity-5" style="background-image: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"60\" height=\"60\"><rect fill=\"none\" width=\"60\" height=\"60\"/><path d=\"M30 0L60 30L30 60L0 30Z\" fill=\"none\" stroke=\"gold\" stroke-width=\"0.5\"/></svg>');"></div>
    
    <div class="w-full max-w-md relative z-10">
        <!-- Logo -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center gap-3 mb-4">
                <div class="w-12 h-12 gold-gradient rounded-xl flex items-center justify-center">
                    <i data-lucide="shield-check" class="w-6 h-6 text-dark-900"></i>
                </div>
                <div class="text-left">
                    <h1 class="text-2xl font-bold text-white">İzmir Tenteci</h1>
                    <p class="text-gold text-sm">Admin Panel</p>
                </div>
            </div>
        </div>
        
        <!-- Login Card -->
        <div class="glass-card rounded-2xl p-8">
            <h2 class="text-xl font-semibold text-white mb-6 text-center">Yönetici Girişi</h2>
            
            <?php if ($error): ?>
            <div class="mb-6 p-4 rounded-lg bg-red-500/10 border border-red-500/30 text-red-400 text-sm flex items-center gap-2">
                <i data-lucide="alert-circle" class="w-5 h-5 flex-shrink-0"></i>
                <span><?= htmlspecialchars($error) ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
            <div class="mb-6 p-4 rounded-lg bg-green-500/10 border border-green-500/30 text-green-400 text-sm flex items-center gap-2">
                <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0"></i>
                <span><?= htmlspecialchars($success) ?></span>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="space-y-5">
                <input type="hidden" name="csrf_token" value="<?= $csrfToken ?>">
                
                <!-- Username -->
                <div>
                    <label class="block text-white/70 text-sm mb-2">Kullanıcı Adı</label>
                    <div class="relative">
                        <i data-lucide="user" class="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-white/40"></i>
                        <input 
                            type="text" 
                            name="username" 
                            required
                            autocomplete="username"
                            class="input-style w-full pl-12 pr-4 py-3 rounded-lg text-white placeholder-white/40 focus:outline-none"
                            placeholder="admin"
                            value="<?= htmlspecialchars($_POST['username'] ?? '') ?>"
                        >
                    </div>
                </div>
                
                <!-- Password -->
                <div>
                    <label class="block text-white/70 text-sm mb-2">Şifre</label>
                    <div class="relative">
                        <i data-lucide="lock" class="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-white/40"></i>
                        <input 
                            type="password" 
                            name="password" 
                            required
                            autocomplete="current-password"
                            class="input-style w-full pl-12 pr-12 py-3 rounded-lg text-white placeholder-white/40 focus:outline-none"
                            placeholder="••••••••"
                        >
                        <button type="button" onclick="togglePassword(this)" class="absolute right-4 top-1/2 -translate-y-1/2 text-white/40 hover:text-white/60">
                            <i data-lucide="eye" class="w-5 h-5"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Remember Me -->
                <div class="flex items-center justify-between">
                    <label class="flex items-center gap-2 cursor-pointer">
                        <input type="checkbox" name="remember" class="w-4 h-4 rounded border-white/20 bg-dark-800 text-gold focus:ring-gold/50">
                        <span class="text-white/60 text-sm">Beni hatırla</span>
                    </label>
                </div>
                
                <!-- Submit -->
                <button 
                    type="submit" 
                    class="w-full gold-gradient text-dark-900 font-semibold py-3 px-6 rounded-lg hover:opacity-90 transition-all flex items-center justify-center gap-2"
                >
                    <i data-lucide="log-in" class="w-5 h-5"></i>
                    Giriş Yap
                </button>
            </form>
        </div>
        
        <!-- Footer -->
        <p class="text-center text-white/30 text-sm mt-6">
            &copy; <?= date('Y') ?> İzmir Tenteci. Tüm hakları saklıdır.
        </p>
    </div>
    
    <script>
        lucide.createIcons();
        
        function togglePassword(btn) {
            const input = btn.parentElement.querySelector('input');
            const icon = btn.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.setAttribute('data-lucide', 'eye-off');
            } else {
                input.type = 'password';
                icon.setAttribute('data-lucide', 'eye');
            }
            lucide.createIcons();
        }
    </script>
</body>
</html>
