        </div><!-- End Page Content -->
    </main>
    
    <!-- Toast Container -->
    <div id="toast-container" class="fixed bottom-6 right-6 z-50 space-y-2"></div>
    
    <script>
        lucide.createIcons();
        
        // Toast function
        function showToast(message, type = 'success') {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            
            const bgColor = {
                success: 'bg-green-500/20 border-green-500/30 text-green-400',
                error: 'bg-red-500/20 border-red-500/30 text-red-400',
                warning: 'bg-yellow-500/20 border-yellow-500/30 text-yellow-400',
                info: 'bg-blue-500/20 border-blue-500/30 text-blue-400'
            }[type];
            
            const icon = {
                success: 'check-circle',
                error: 'x-circle',
                warning: 'alert-triangle',
                info: 'info'
            }[type];
            
            toast.className = `${bgColor} border rounded-lg p-4 flex items-center gap-3 min-w-64 animate-slide-in`;
            toast.innerHTML = `
                <i data-lucide="${icon}" class="w-5 h-5"></i>
                <span class="flex-1">${message}</span>
                <button onclick="this.parentElement.remove()" class="opacity-60 hover:opacity-100">
                    <i data-lucide="x" class="w-4 h-4"></i>
                </button>
            `;
            
            container.appendChild(toast);
            lucide.createIcons();
            
            setTimeout(() => {
                toast.remove();
            }, 5000);
        }
        
        // AJAX helper
        async function apiRequest(url, data = {}, method = 'POST') {
            try {
                const response = await fetch(url, {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: method !== 'GET' ? JSON.stringify(data) : undefined
                });
                
                return await response.json();
            } catch (error) {
                console.error('API Error:', error);
                return { success: false, error: 'Bağlantı hatası' };
            }
        }
        
        // Confirm dialog
        function confirmAction(message) {
            return new Promise((resolve) => {
                const modal = document.createElement('div');
                modal.className = 'fixed inset-0 z-[100] flex items-center justify-center p-4 bg-black/50';
                modal.innerHTML = `
                    <div class="glass-card rounded-2xl p-6 max-w-md w-full">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-12 h-12 rounded-full bg-yellow-500/20 flex items-center justify-center">
                                <i data-lucide="alert-triangle" class="w-6 h-6 text-yellow-400"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-white">Emin misiniz?</h3>
                                <p class="text-white/60 text-sm">${message}</p>
                            </div>
                        </div>
                        <div class="flex gap-3 justify-end">
                            <button onclick="this.closest('.fixed').remove(); window.confirmResolve(false);" class="px-4 py-2 rounded-lg bg-white/10 text-white hover:bg-white/20">
                                İptal
                            </button>
                            <button onclick="this.closest('.fixed').remove(); window.confirmResolve(true);" class="px-4 py-2 rounded-lg bg-red-500 text-white hover:bg-red-600">
                                Evet, Sil
                            </button>
                        </div>
                    </div>
                `;
                
                document.body.appendChild(modal);
                lucide.createIcons();
                
                window.confirmResolve = resolve;
            });
        }
    </script>
    
    <style>
        @keyframes slide-in {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        .animate-slide-in {
            animation: slide-in 0.3s ease-out;
        }
    </style>
</body>
</html>
