<?php
/**
 * Admin Header Partial
 * Aegean Dominance Admin Panel
 */

// Get current admin user from session or database
$admin = null;
if (isset($_SESSION['admin_id'])) {
    $admin = Database::getInstance()->fetchOne(
        "SELECT id, username, full_name, role FROM admins WHERE id = ?",
        [$_SESSION['admin_id']]
    );
}
// Fallback defaults
if (!$admin) {
    $admin = [
        'full_name' => 'Admin',
        'role' => 'admin',
        'username' => 'admin'
    ];
}

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$pageTitle = [
    'index' => 'Dashboard',
    'services' => 'Hizmetler',
    'gallery' => 'Galeri',
    'leads' => 'Başvurular',
    'blog' => 'Blog',
    'cities' => 'Şehirler',
    'network' => 'Network',
    'settings' => 'Ayarlar',
    'seo' => 'SEO Araçları',
    'api' => 'API Entegrasyonları',
    'conductor' => 'SEO Conductor'
][$currentPage] ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?= $pageTitle ?> | İzmir Tenteci Admin</title>
    
    <!-- TailwindCSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        dark: {
                            900: '#0a0a0a',
                            800: '#121212',
                            700: '#1a1a1a',
                            600: '#222222'
                        },
                        gold: {
                            DEFAULT: '#D4AF37',
                            light: '#E6C65C',
                            dark: '#B8942F'
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        body {
            background: #0a0a0a;
        }
        .glass-card {
            background: rgba(26, 26, 26, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(212, 175, 55, 0.15);
        }
        .gold-gradient {
            background: linear-gradient(135deg, #D4AF37 0%, #E6C65C 50%, #D4AF37 100%);
        }
        .sidebar-link {
            transition: all 0.2s ease;
        }
        .sidebar-link:hover {
            background: rgba(212, 175, 55, 0.1);
        }
        .sidebar-link.active {
            background: rgba(212, 175, 55, 0.15);
            border-right: 3px solid #D4AF37;
        }
        .scrollbar-thin::-webkit-scrollbar {
            width: 6px;
        }
        .scrollbar-thin::-webkit-scrollbar-track {
            background: rgba(255,255,255,0.05);
        }
        .scrollbar-thin::-webkit-scrollbar-thumb {
            background: rgba(212, 175, 55, 0.3);
            border-radius: 3px;
        }
    </style>
</head>
<body class="flex min-h-screen" x-data="{ sidebarOpen: true, mobileMenu: false }">
    
    <!-- Sidebar -->
    <aside 
        class="fixed lg:relative w-64 h-screen bg-dark-800 border-r border-white/10 z-50 transition-transform lg:translate-x-0"
        :class="{ '-translate-x-full': !sidebarOpen && !mobileMenu, 'translate-x-0': mobileMenu }"
    >
        <div class="flex flex-col h-full">
            <!-- Logo -->
            <div class="p-6 border-b border-white/10">
                <a href="index.php" class="flex items-center gap-3">
                    <div class="w-10 h-10 gold-gradient rounded-lg flex items-center justify-center">
                        <i data-lucide="shield" class="w-5 h-5 text-dark-900"></i>
                    </div>
                    <div>
                        <h1 class="text-white font-bold">İzmir Tenteci</h1>
                        <p class="text-gold text-xs">Admin Panel</p>
                    </div>
                </a>
            </div>
            
            <!-- Navigation -->
            <nav class="flex-1 p-4 overflow-y-auto scrollbar-thin">
                <div class="space-y-1">
                    <a href="index.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'index' ? 'active text-gold' : '' ?>">
                        <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                        <span>Dashboard</span>
                    </a>
                    
                    <p class="text-white/30 text-xs uppercase mt-6 mb-2 px-4">İçerik</p>
                    
                    <a href="services.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'services' ? 'active text-gold' : '' ?>">
                        <i data-lucide="briefcase" class="w-5 h-5"></i>
                        <span>Hizmetler</span>
                    </a>
                    
                    <a href="gallery.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'gallery' ? 'active text-gold' : '' ?>">
                        <i data-lucide="image" class="w-5 h-5"></i>
                        <span>Galeri</span>
                    </a>
                    
                    <a href="blog.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'blog' ? 'active text-gold' : '' ?>">
                        <i data-lucide="file-text" class="w-5 h-5"></i>
                        <span>Blog</span>
                    </a>
                    
                    <a href="leads.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'leads' ? 'active text-gold' : '' ?>">
                        <i data-lucide="message-square" class="w-5 h-5"></i>
                        <span>Başvurular</span>
                        <?php 
                        $newLeads = Database::getInstance()->fetchColumn("SELECT COUNT(*) FROM contact_forms WHERE status = 'new'");
                        if ($newLeads > 0): 
                        ?>
                        <span class="ml-auto bg-gold text-dark-900 text-xs font-bold px-2 py-0.5 rounded-full"><?= $newLeads ?></span>
                        <?php endif; ?>
                    </a>
                    
                    <p class="text-white/30 text-xs uppercase mt-6 mb-2 px-4">SEO & Network</p>
                    
                    <a href="cities.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'cities' ? 'active text-gold' : '' ?>">
                        <i data-lucide="map-pin" class="w-5 h-5"></i>
                        <span>Şehir Landing</span>
                    </a>
                    
                    <a href="conductor.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'conductor' ? 'active text-gold' : '' ?>">
                        <i data-lucide="zap" class="w-5 h-5"></i>
                        <span>SEO Conductor</span>
                    </a>
                    
                    <a href="network.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'network' ? 'active text-gold' : '' ?>">
                        <i data-lucide="globe" class="w-5 h-5"></i>
                        <span>Network Yönetimi</span>
                    </a>
                    
                    <a href="seo.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'seo' ? 'active text-gold' : '' ?>">
                        <i data-lucide="search" class="w-5 h-5"></i>
                        <span>SEO Araçları</span>
                    </a>
                    
                    <p class="text-white/30 text-xs uppercase mt-6 mb-2 px-4">Sistem</p>
                    
                    <a href="api.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'api' ? 'active text-gold' : '' ?>">
                        <i data-lucide="cloud" class="w-5 h-5"></i>
                        <span>API Ayarları</span>
                    </a>
                    
                    <a href="settings.php" class="sidebar-link flex items-center gap-3 px-4 py-3 rounded-lg text-white/80 <?= $currentPage === 'settings' ? 'active text-gold' : '' ?>">
                        <i data-lucide="settings" class="w-5 h-5"></i>
                        <span>Site Ayarları</span>
                    </a>
                </div>
            </nav>
            
            <!-- User -->
            <div class="p-4 border-t border-white/10">
                <div class="flex items-center gap-3 px-4 py-3">
                    <div class="w-10 h-10 rounded-full bg-gold/20 flex items-center justify-center">
                        <span class="text-gold font-semibold"><?= strtoupper(mb_substr($admin['full_name'], 0, 1)) ?></span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-white text-sm truncate"><?= htmlspecialchars($admin['full_name']) ?></p>
                        <p class="text-white/40 text-xs"><?= ucfirst($admin['role']) ?></p>
                    </div>
                    <a href="logout.php" class="text-white/40 hover:text-red-400" title="Çıkış">
                        <i data-lucide="log-out" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
        </div>
    </aside>
    
    <!-- Mobile Overlay -->
    <div 
        class="fixed inset-0 bg-black/50 z-40 lg:hidden" 
        x-show="mobileMenu"
        @click="mobileMenu = false"
    ></div>
    
    <!-- Main Content -->
    <main class="flex-1 lg:ml-0 min-h-screen">
        <!-- Top Bar -->
        <header class="sticky top-0 z-30 glass-card border-b border-white/10">
            <div class="flex items-center justify-between px-6 py-4">
                <div class="flex items-center gap-4">
                    <button @click="mobileMenu = !mobileMenu" class="lg:hidden text-white/60 hover:text-white">
                        <i data-lucide="menu" class="w-6 h-6"></i>
                    </button>
                    <h2 class="text-xl font-semibold text-white"><?= $pageTitle ?></h2>
                </div>
                
                <div class="flex items-center gap-4">
                    <!-- Site Link -->
                    <a href="<?= BASE_URL ?>" target="_blank" class="text-white/60 hover:text-white flex items-center gap-2">
                        <i data-lucide="external-link" class="w-5 h-5"></i>
                        <span class="hidden sm:inline text-sm">Siteyi Görüntüle</span>
                    </a>
                </div>
            </div>
        </header>
        
        <!-- Page Content -->
        <div class="min-h-[calc(100vh-73px)]">
