<?php
/**
 * Settings Management
 * Aegean Dominance Admin Panel
 */

session_start();
require_once __DIR__ . '/../config/config.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();

// AJAX İşlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SERVER['HTTP_X_REQUESTED_WITH'])) {
    header('Content-Type: application/json');
    
    $input = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? '';
    
    try {
        switch ($action) {
            case 'save_settings':
                $settings = $input['settings'] ?? [];
                
                foreach ($settings as $key => $value) {
                    $db->execute(
                        "UPDATE settings SET setting_value = ? WHERE setting_key = ?",
                        [$value, $key]
                    );
                }
                
                echo json_encode(['success' => true, 'message' => 'Ayarlar kaydedildi.']);
                break;
                
            default:
                echo json_encode(['success' => false, 'error' => 'Geçersiz işlem.']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
    exit;
}

// Form gönderimi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_SERVER['HTTP_X_REQUESTED_WITH'])) {
    try {
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'setting_') === 0) {
                $settingKey = substr($key, 8);
                $db->execute(
                    "UPDATE settings SET setting_value = ? WHERE setting_key = ?",
                    [$value, $settingKey]
                );
            }
        }
        
        $success = 'Ayarlar başarıyla kaydedildi.';
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

// Ayarları kategorilere göre grupla
$allSettings = $db->fetchAll("SELECT * FROM settings ORDER BY category, id");
$settings = [];
foreach ($allSettings as $s) {
    $settings[$s['category']][] = $s;
}

$categories = [
    'general' => ['label' => 'Genel Ayarlar', 'icon' => 'settings'],
    'contact' => ['label' => 'İletişim Bilgileri', 'icon' => 'phone'],
    'map' => ['label' => 'Harita Ayarları', 'icon' => 'map-pin'],
    'social' => ['label' => 'Sosyal Medya', 'icon' => 'share-2'],
    'seo' => ['label' => 'SEO Ayarları', 'icon' => 'search']
];

include 'partials/header.php';
?>

<div class="p-6">
    <?php if (isset($success)): ?>
    <div class="mb-6 p-4 rounded-lg bg-green-500/10 border border-green-500/30 text-green-400 flex items-center gap-2">
        <i data-lucide="check-circle" class="w-5 h-5"></i>
        <span><?= htmlspecialchars($success) ?></span>
    </div>
    <?php endif; ?>
    
    <?php if (isset($error)): ?>
    <div class="mb-6 p-4 rounded-lg bg-red-500/10 border border-red-500/30 text-red-400 flex items-center gap-2">
        <i data-lucide="alert-circle" class="w-5 h-5"></i>
        <span><?= htmlspecialchars($error) ?></span>
    </div>
    <?php endif; ?>
    
    <form method="POST">
        <div class="flex items-center justify-between mb-6">
            <div>
                <h2 class="text-xl font-semibold text-white">Site Ayarları</h2>
                <p class="text-white/60 text-sm">Genel site ayarlarını buradan düzenleyebilirsiniz</p>
            </div>
            <button type="submit" class="gold-gradient text-dark-900 font-semibold py-2 px-6 rounded-lg hover:opacity-90 flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5"></i>
                Kaydet
            </button>
        </div>
        
        <!-- Tabs -->
        <div x-data="{ activeTab: 'general' }">
            <div class="flex gap-2 mb-6 overflow-x-auto pb-2">
                <?php foreach ($categories as $catKey => $cat): ?>
                <button 
                    type="button"
                    @click="activeTab = '<?= $catKey ?>'"
                    :class="activeTab === '<?= $catKey ?>' ? 'bg-gold text-dark-900' : 'bg-dark-700 text-white/60 hover:text-white'"
                    class="flex items-center gap-2 px-4 py-2 rounded-lg font-medium transition-colors whitespace-nowrap"
                >
                    <i data-lucide="<?= $cat['icon'] ?>" class="w-4 h-4"></i>
                    <?= $cat['label'] ?>
                </button>
                <?php endforeach; ?>
            </div>
            
            <?php foreach ($categories as $catKey => $cat): ?>
            <div x-show="activeTab === '<?= $catKey ?>'" class="glass-card rounded-2xl p-6">
                <h3 class="text-lg font-semibold text-white mb-6 flex items-center gap-2">
                    <i data-lucide="<?= $cat['icon'] ?>" class="w-5 h-5 text-gold"></i>
                    <?= $cat['label'] ?>
                </h3>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <?php if (isset($settings[$catKey])): ?>
                    <?php foreach ($settings[$catKey] as $setting): ?>
                    <div>
                        <label class="block text-white/70 text-sm mb-2"><?= htmlspecialchars($setting['description'] ?: $setting['setting_key']) ?></label>
                        
                        <?php if ($setting['setting_type'] === 'boolean'): ?>
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="hidden" name="setting_<?= $setting['setting_key'] ?>" value="0">
                            <input type="checkbox" name="setting_<?= $setting['setting_key'] ?>" value="1"
                                class="sr-only peer" <?= $setting['setting_value'] ? 'checked' : '' ?>>
                            <div class="w-11 h-6 bg-dark-600 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-gold"></div>
                        </label>
                        
                        <?php elseif (strlen($setting['setting_value']) > 100): ?>
                        <textarea name="setting_<?= $setting['setting_key'] ?>" rows="3"
                            class="w-full bg-dark-800 border border-white/10 rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none"
                        ><?= htmlspecialchars($setting['setting_value']) ?></textarea>
                        
                        <?php else: ?>
                        <input type="text" name="setting_<?= $setting['setting_key'] ?>"
                            class="w-full bg-dark-800 border border-white/10 rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none"
                            value="<?= htmlspecialchars($setting['setting_value']) ?>">
                        <?php endif; ?>
                        
                        <p class="text-white/30 text-xs mt-1"><?= $setting['setting_key'] ?></p>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </form>
</div>

<?php include 'partials/footer.php'; ?>
