<?php
/**
 * Aegean Dominance - Configuration
 * İzmir Tenteci V2
 */

declare(strict_types=1);

// =====================================================
// ENVIRONMENT
// =====================================================
define('APP_ENV', 'development'); // production | development
define('APP_DEBUG', APP_ENV === 'development');

// =====================================================
// DATABASE
// =====================================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'dekorasyon');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// =====================================================
// PATHS
// =====================================================
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('VIEWS_PATH', ROOT_PATH . '/views');
define('CLASSES_PATH', ROOT_PATH . '/classes');
define('UPLOADS_PATH', PUBLIC_PATH . '/assets/images/uploads');
define('PRODUCTS_PATH', PUBLIC_PATH . '/urunler'); // Ürün görselleri

// =====================================================
// URLS
// =====================================================
define('BASE_URL', '/v2/public');
define('ASSETS_URL', BASE_URL . '/assets');
define('IMAGES_URL', ASSETS_URL . '/images');

// =====================================================
// SITE INFO
// =====================================================
define('SITE_NAME', 'Yapı Dekorasyon');
define('SITE_SLOGAN', 'Hayalinizdeki Mekanı Yaratıyoruz');
define('SITE_EMAIL', 'info@yapidekorasyon.com');
define('SITE_PHONE', '05362771709');
define('SITE_WHATSAPP', '905362771709');
define('SITE_ADDRESS', 'İzmir, Türkiye');

// =====================================================
// DESIGN TOKENS (Dark/Gold Theme)
// =====================================================
define('THEME_BG', '#0a0a0a');
define('THEME_TEXT', '#f3f4f6');
define('THEME_GOLD', '#D4AF37');
define('THEME_GOLD_LIGHT', '#E5C158');
define('THEME_CARD', '#111111');
define('THEME_BORDER', '#1f1f1f');

// =====================================================
// SEO DEFAULTS
// =====================================================
define('SEO_TITLE', 'Yapı Dekorasyon | İç Mekan Tasarımı & Tadilat');
define('SEO_DESCRIPTION', 'Profesyonel iç mekan tasarımı, dekorasyon, tadilat ve yenileme hizmetleri. Hayalinizdeki mekanı birlikte tasarlayalım.');
define('SEO_KEYWORDS', 'iç mimarlık, dekorasyon, tadilat, yenileme, boya badana, alçıpan, laminat parke, mutfak yenileme');

// =====================================================
// DOMAIN NETWORK (Sister Sites)
// =====================================================
define('DOMAIN_NETWORK', [
    'izmirdekorasyon.com' => 'İzmir Dekorasyon',
    'manisadekorasyon.com' => 'Manisa Dekorasyon',
    'denizlidekorasyon.com' => 'Denizli Dekorasyon'
]);

// =====================================================
// TIMEZONE & LOCALE
// =====================================================
date_default_timezone_set('Europe/Istanbul');
setlocale(LC_TIME, 'tr_TR.UTF-8', 'Turkish');

// =====================================================
// ERROR HANDLING
// =====================================================
if (APP_DEBUG) {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
} else {
    error_reporting(0);
    ini_set('display_errors', '0');
    ini_set('log_errors', '1');
    ini_set('error_log', ROOT_PATH . '/logs/error.log');
}

// =====================================================
// SESSION
// =====================================================
if (session_status() === PHP_SESSION_NONE) {
    session_name('yapidekorasyon_session');
    session_start();
}

// =====================================================
// AUTOLOADER
// =====================================================
spl_autoload_register(function (string $class): void {
    $file = CLASSES_PATH . '/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// =====================================================
// CORE CLASSES & HELPERS
// =====================================================
// Load core classes that have helper functions
require_once CLASSES_PATH . '/Database.php';
require_once CLASSES_PATH . '/Router.php';
require_once CLASSES_PATH . '/SeoManager.php';
require_once CLASSES_PATH . '/SiteSettings.php';
