<?php
/**
 * Cron Job Entry Point
 * Aegean Dominance - İzmir Tenteci V2
 * 
 * Sunucu tarafından periyodik olarak çağrılır (Örn: Her gece 03:00)
 * Örn: php /path/to/site/v2/cron.php
 */

// CLI veya web üzerinden güvenli erişim kontrolü
if (php_sapi_name() !== 'cli' && !isset($_GET['key'])) {
    die('Erişim reddedildi.');
}

// Güvenlik anahtarı kontrolü (Web üzerinden tetiklenirse)
$cronKey = 'AegeanCronSecret2025';
if (php_sapi_name() !== 'cli' && $_GET['key'] !== $cronKey) {
    die('Geçersiz anahtar.');
}

require_once __DIR__ . '/config/config.php';

header('Content-Type: application/json');

try {
    $conductor = new Conductor();
    
    // Oto-Pilot kontrolü Conductor içinde yapılır
    $result = $conductor->runAutoPilotRoutine();
    
    echo json_encode([
        'status' => 'success',
        'timestamp' => date('Y-m-d H:i:s'),
        'result' => $result
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
