<?php
/**
 * Gelişmiş Veritabanı Kurulum Script - PDO Multi-Statement Desteğiyle
 */

require_once __DIR__ . '/../config/config.php';

echo "<!DOCTYPE html><html><head><meta charset='utf-8'><style>body{font-family:monospace;padding:20px;background:#0a0a0a;color:#f3f4f6;} .success{color:#22c55e;} .error{color:#ef4444;} .info{color:#3b82f6;} h2{color:#c9a74e;border-bottom:2px solid #c9a74e;padding-bottom:10px;}</style></head><body>";

try {
    echo "<h2>🔧 Veritabanı Kurulumu Başlatılıyor</h2>\n";
    
    // Veritabanı olmadan bağlan
    $dsn = "mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    echo "<p class='success'>✓ MySQL bağlantısı başarılı</p>\n";
    
    // Veritabanını oluştur
    echo "<p class='info'>→ Veritabanı oluşturuluyor...</p>\n";
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `dekorasyon` CHARACTER SET utf8mb4 COLLATE utf8mb4_turkish_ci");
    $pdo->exec("USE `dekorasyon`");
    echo "<p class='success'>✓ Veritabanı: dekorasyon</p>\n";
    
    // Schema dosyasını oku
    $sqlFile = __DIR__ . '/schema_dekorasyon.sql';
    $sql = file_get_contents($sqlFile);
    
    // SQL'i satır satır parse et ve çalıştır
    $statements = [];
    $buffer = '';
    $lines = explode("\n", $sql);
    
    foreach ($lines as $line) {
        $line = trim($line);
        
        // Boş satırları ve yorumları atla
        if (empty($line) || strpos($line, '--') === 0 || strpos($line, '#') === 0) {
            continue;
        }
        
        // SQL komutunu buffer'a ekle
        $buffer .= $line . ' ';
        
        // Eğer satır ; ile bitiyorsa, bu bir komut sonu
        if (substr($line, -1) === ';') {
            $buffer = trim($buffer);
            if (!empty($buffer) && stripos($buffer, 'USE ') !== 0) {
                $statements[] = $buffer;
            }
            $buffer = '';
        }
    }
    
    echo "<p class='info'>→ " . count($statements) . " SQL komutu bulundu</p>\n";
    echo "<h2>📊 Tablolar Oluşturuluyor</h2>\n";
    
    $created = 0;
    $skipped = 0;
    
    foreach ($statements as $statement) {
        try {
            $pdo->exec($statement);
            
            // Tablo adını çıkar
            if (preg_match('/CREATE TABLE.*?`([^`]+)`/i', $statement, $matches)) {
                echo "<p class='success'>✓ " . $matches[1] . "</p>\n";
                $created++;
            } elseif (preg_match('/INSERT INTO.*?`([^`]+)`/i', $statement, $matches)) {
                // Insert komutlarını sessizce çalıştır
            }
            
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'already exists') !== false) {
                $skipped++;
            } else {
                echo "<p class='error'>✗ " . substr($statement, 0, 50) . "...</p>\n";
                echo "<p class='error'>  Hata: " . $e->getMessage() . "</p>\n";
            }
        }
    }
    
    echo "<h2>✨ Kurulum Tamamlandı</h2>\n";
    echo "<p>Oluşturulan tablolar: <strong>{$created}</strong></p>\n"; 
    
    // Tabloları doğrula
    echo "<h2>🔍 Tabloları Doğrulama</h2>\n";
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    foreach ($tables as $table) {
        $count = $pdo->query("SELECT COUNT(*) FROM `{$table}`")->fetchColumn();
        echo "<p class='success'>✓ {$table} ({$count} kayıt)</p>\n";
    }
    
    echo "<h2>🔐 Admin Bilgileri</h2>\n";
    echo "<p><strong>Kullanıcı Adı:</strong> admin</p>\n";
    echo "<p><strong>Şifre:</strong> admin123</p>\n";
    echo "<p><strong>Panel:</strong> <a href='/v2/public/admin' style='color:#c9a74e;'>/admin</a></p>\n";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ HATA: " . $e->getMessage() . "</p>\n";
}

echo "</body></html>";
?>
