<?php
/**
 * ImageHandler Runner Script
 * Görsel dağıtımını çalıştır
 */

require_once __DIR__ . '/../config/config.php';

echo "<h1>ImageHandler - Görsel Dağıtımı</h1>";
echo "<pre style='background:#1a1a1a;color:#f3f4f6;padding:20px;border-radius:8px;'>";

try {
    $handler = new ImageHandler();
    $log = $handler->run();
    
    foreach ($log as $line) {
        echo $line . "\n";
    }
    
    // Sonuç özeti
    $totalImages = db()->fetchColumn("SELECT COUNT(*) FROM service_images");
    echo "\n📊 Toplam dağıtılan görsel: {$totalImages}\n";
    
} catch (Exception $e) {
    echo "❌ HATA: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><a href='../public/' style='color:#D4AF37;font-weight:bold;'>🏠 Ana Sayfaya Git →</a></p>";
?>
