-- =====================================================
-- AEGEAN DOMINANCE - İZMİR TENTECİ V2
-- Modern Database Schema
-- =====================================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+03:00";

CREATE DATABASE IF NOT EXISTS `izmirtenteci_v2` 
CHARACTER SET utf8mb4 COLLATE utf8mb4_turkish_ci;

USE `izmirtenteci_v2`;

-- =====================================================
-- ADMINS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `admins` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(50) NOT NULL UNIQUE,
    `password` VARCHAR(255) NOT NULL,
    `email` VARCHAR(100) NOT NULL,
    `full_name` VARCHAR(100) NOT NULL,
    `role` ENUM('admin', 'editor') DEFAULT 'admin',
    `is_active` TINYINT(1) DEFAULT 1,
    `last_login` DATETIME NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_username` (`username`),
    INDEX `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default admin (password: admin123)
INSERT INTO `admins` (`username`, `password`, `email`, `full_name`, `role`) VALUES
('admin', '$2y$10$CEorUqsAujBFie5cElkakeDhUZHFqpj0Fc2HhuYDNIVKQ8wRDMHam', 'info@izmirtenteci.com', 'Site Yöneticisi', 'admin');

-- =====================================================
-- SETTINGS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `settings` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `setting_key` VARCHAR(100) NOT NULL UNIQUE,
    `setting_value` TEXT,
    `setting_type` ENUM('text', 'number', 'boolean', 'json') DEFAULT 'text',
    `category` VARCHAR(50) DEFAULT 'general',
    `description` VARCHAR(255),
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_category` (`category`),
    INDEX `idx_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_type`, `category`, `description`) VALUES
-- General
('site_name', 'İzmir Tenteci', 'text', 'general', 'Site adı'),
('site_slogan', 'Gölgeyi Tasarlıyoruz', 'text', 'general', 'Site sloganı'),
('site_description', 'İzmir ve Ege Bölgesi Tente, Pergola ve Cam Balkon Sistemleri', 'text', 'general', 'Site açıklaması'),
-- Contact
('contact_phone', '05362771709', 'text', 'contact', 'Telefon'),
('contact_phone_2', '05362771709', 'text', 'contact', 'Telefon 2'),
('contact_whatsapp', '905362771709', 'text', 'contact', 'WhatsApp'),
('contact_email', 'info@izmirtenteci.com', 'text', 'contact', 'Email'),
('contact_address', 'Cennetoğlu, 5757. Sk. 22/C, 35110 Karabağlar/İzmir', 'text', 'contact', 'Adres'),
('working_hours', 'Pazartesi - Cumartesi: 09:00 - 18:00', 'text', 'contact', 'Çalışma saatleri'),
-- Map
('map_latitude', '38.3920', 'text', 'map', 'Harita enlem'),
('map_longitude', '27.0550', 'text', 'map', 'Harita boylam'),
-- Social
('social_facebook', 'https://facebook.com/izmirtenteci', 'text', 'social', 'Facebook'),
('social_instagram', 'https://instagram.com/izmirtenteci', 'text', 'social', 'Instagram'),
('social_twitter', 'https://twitter.com/izmirtenteci', 'text', 'social', 'Twitter'),
-- SEO
('seo_title', 'İzmir Tenteci | Tente, Pergola ve Cam Balkon Sistemleri', 'text', 'seo', 'SEO başlık'),
('seo_description', 'İzmir ve Ege Bölgesinde 35 yıllık tecrübe ile profesyonel tente, pergola ve cam balkon sistemleri.', 'text', 'seo', 'SEO açıklama'),
('seo_keywords', 'izmir tente, pergola, bioklimatik pergola, cam balkon, zip perde', 'text', 'seo', 'SEO anahtar kelimeler');

-- =====================================================
-- SERVICES TABLE (18 Hizmet)
-- =====================================================
CREATE TABLE IF NOT EXISTS `services` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(200) NOT NULL,
    `slug` VARCHAR(200) NOT NULL UNIQUE,
    `short_description` TEXT,
    `description` LONGTEXT,
    `features` JSON,
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `meta_keywords` VARCHAR(255),
    `featured_image` VARCHAR(500),
    `icon` VARCHAR(100) DEFAULT 'umbrella',
    `category` VARCHAR(100),
    `price_range` VARCHAR(100) DEFAULT 'Projeye özel fiyatlandırma',
    `display_order` INT DEFAULT 0,
    `is_featured` TINYINT(1) DEFAULT 0,
    `is_active` TINYINT(1) DEFAULT 1,
    `view_count` INT UNSIGNED DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_category` (`category`),
    INDEX `idx_featured` (`is_featured`),
    INDEX `idx_order` (`display_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- 18 Services
INSERT INTO `services` (`name`, `slug`, `short_description`, `category`, `icon`, `display_order`, `is_featured`) VALUES
('Bioklimatik Pergola', 'bioklimatik-pergola', 'Ayarlanabilir alüminyum lamellerle güneş, yağmur ve rüzgara karşı üstün koruma. Motorlu açılır-kapanır çatı sistemi.', 'Pergola', 'sun', 1, 1),
('Pergola Tente', 'pergola-tente', 'Geniş alanlar için ideal, estetik ve dayanıklı pergola tente sistemleri.', 'Pergola', 'umbrella-beach', 2, 1),
('Askılı Pergola', 'askili-pergola', 'Duvara monte, kolonssuz şık pergola çözümleri.', 'Pergola', 'columns', 3, 0),
('Radyal Pergola', 'radyal-pergola', 'Yuvarlak ve kavisli tasarımlar için radyal pergola sistemleri.', 'Pergola', 'circle', 4, 0),
('Çift Açılır Pergola', 'cift-acilir-pergola', 'Her iki yöne açılabilen esnek pergola sistemleri.', 'Pergola', 'arrows-left-right', 5, 0),
('Mafsallı Tente', 'mafsalli-tente', 'Klasik tasarım, motorlu veya manuel açılım seçenekleri ile balkon ve teraslar için ideal.', 'Tente', 'store', 6, 1),
('Kasetli Tente', 'kasetli-tente', 'Kapalıyken tamamen korunaklı, uzun ömürlü premium tente sistemi.', 'Tente', 'box', 7, 0),
('Wintent Tente', 'wintent-tente', 'Kış aylarında da kullanılabilen dayanıklı tente sistemleri.', 'Tente', 'snowflake', 8, 0),
('Karpuz Tente', 'karpuz-tente', 'Şık görünümlü, dükkan ve cafe girişleri için karpuz tente.', 'Tente', 'shopping-bag', 9, 0),
('Zip Perde', 'zip-perde', 'Rüzgar ve yağmura karşı tam koruma sağlayan modern zip perde sistemleri.', 'Perde', 'align-justify', 10, 1),
('Tavan Zip Perde', 'tavan-zip-perde', 'Tavan uygulamaları için özel zip perde çözümleri.', 'Perde', 'maximize', 11, 0),
('Cam Tavan Sistemleri', 'cam-tavan-sistemleri', 'Işık geçirgen, estetik cam tavan uygulamaları.', 'Cam', 'window-maximize', 12, 1),
('Giyotin Cam Sistemleri', 'giyotin-cam-sistemleri', 'Yukarı-aşağı açılan modern giyotin cam balkon sistemleri.', 'Cam', 'th-large', 13, 0),
('Sürgülü Cam Balkon', 'surgulu-cam-balkon', 'Yatay sürgülü, esnez cam balkon kapatma sistemleri.', 'Cam', 'arrows-alt-h', 14, 1),
('Bombeli Askılı Pergola', 'bombeli-askili-pergola', 'Bombeli tasarımlı şık askılı pergola sistemleri.', 'Pergola', 'wave-square', 15, 0),
('Çift Açılır Askılı', 'cift-acilir-askili', 'Çift yönlü açılabilen askılı pergola tasarımları.', 'Pergola', 'swap', 16, 0),
('Radyal Çift Açılır', 'radyal-cift-acilir', 'Radyal tasarımlı çift açılır pergola sistemleri.', 'Pergola', 'rotate-cw', 17, 0),
('Rolling Roof', 'rolling-roof', 'Açılır kapanır çatı sistemleri, modern tasarım.', 'Pergola', 'home', 18, 0);

-- =====================================================
-- SERVICE IMAGES TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `service_images` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `service_id` INT UNSIGNED NOT NULL,
    `image_path` VARCHAR(500) NOT NULL,
    `image_webp` VARCHAR(500),
    `alt_text` VARCHAR(255),
    `display_order` INT DEFAULT 0,
    `is_featured` TINYINT(1) DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_service` (`service_id`),
    INDEX `idx_order` (`display_order`),
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- CITIES TABLE (Multi-city landing pages)
-- =====================================================
CREATE TABLE IF NOT EXISTS `cities` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `slug` VARCHAR(100) NOT NULL UNIQUE,
    `region` VARCHAR(100) DEFAULT 'Ege',
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `content` LONGTEXT,
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_region` (`region`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Cities
INSERT INTO `cities` (`name`, `slug`, `region`, `display_order`) VALUES
('İzmir', 'izmir', 'Ege', 1),
('Manisa', 'manisa', 'Ege', 2),
('Aydın', 'aydin', 'Ege', 3),
('Denizli', 'denizli', 'Ege', 4),
('Muğla', 'mugla', 'Ege', 5);

-- =====================================================
-- TESTIMONIALS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `testimonials` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `customer_name` VARCHAR(100) NOT NULL,
    `customer_location` VARCHAR(100),
    `customer_image` VARCHAR(500),
    `content` TEXT NOT NULL,
    `rating` TINYINT UNSIGNED DEFAULT 5,
    `service_type` VARCHAR(100),
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_active` (`is_active`),
    INDEX `idx_rating` (`rating`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Sample testimonials
INSERT INTO `testimonials` (`customer_name`, `customer_location`, `content`, `rating`, `service_type`) VALUES
('Ahmet Yılmaz', 'İzmir, Karşıyaka', 'Bioklimatik pergola sistemi terasımızı tamamen değiştirdi. Hem güneşten korunuyoruz hem de istediğimizde gökyüzünü görebiliyoruz. Harika bir hizmet aldık.', 5, 'Bioklimatik Pergola'),
('Ayşe Kaya', 'İzmir, Bornova', 'Profesyonel ekip, kaliteli malzeme ve zamanında teslimat. İzmir Tenteci''yi gönül rahatlığıyla tavsiye ediyorum.', 5, 'Mafsallı Tente'),
('Mehmet Demir', 'İzmir, Konak', 'Zip perde sistemi kış aylarında bile terasımızı kullanmamızı sağladı. Rüzgar ve yağmura karşı mükemmel koruma.', 5, 'Zip Perde'),
('Fatma Özkan', 'İzmir, Alsancak', 'Cam balkon sistemimiz 3 yıldır sorunsuz çalışıyor. Servis ekibi de çok ilgili.', 5, 'Sürgülü Cam Balkon');

-- =====================================================
-- PROJECTS TABLE (Portfolio)
-- =====================================================
CREATE TABLE IF NOT EXISTS `projects` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `title` VARCHAR(200) NOT NULL,
    `slug` VARCHAR(200) NOT NULL UNIQUE,
    `description` TEXT,
    `location` VARCHAR(200),
    `service_id` INT UNSIGNED,
    `featured_image` VARCHAR(500),
    `completion_date` DATE,
    `is_featured` TINYINT(1) DEFAULT 0,
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_service` (`service_id`),
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- CONTACT FORMS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `contact_forms` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `form_type` ENUM('contact', 'quote') DEFAULT 'contact',
    `name` VARCHAR(100) NOT NULL,
    `email` VARCHAR(100),
    `phone` VARCHAR(20) NOT NULL,
    `service_type` VARCHAR(100),
    `message` TEXT,
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    `status` ENUM('new', 'read', 'replied', 'closed') DEFAULT 'new',
    `admin_note` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_status` (`status`),
    INDEX `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- BLOG POSTS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `blog_posts` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `title` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL UNIQUE,
    `excerpt` TEXT,
    `content` LONGTEXT,
    `featured_image` VARCHAR(500),
    `category` VARCHAR(100) DEFAULT 'Genel',
    `tags` VARCHAR(255),
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `author` VARCHAR(100) DEFAULT 'İzmir Tenteci',
    `status` ENUM('draft', 'published', 'scheduled') DEFAULT 'draft',
    `published_at` DATETIME,
    `view_count` INT UNSIGNED DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_status` (`status`),
    INDEX `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- VISITORS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `visitors` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `ip_address` VARCHAR(45) NOT NULL,
    `user_agent` TEXT,
    `page_url` VARCHAR(500),
    `referrer` VARCHAR(500),
    `device_type` ENUM('Desktop', 'Mobile', 'Tablet', 'Bot') DEFAULT 'Desktop',
    `browser` VARCHAR(100),
    `country` VARCHAR(100),
    `city` VARCHAR(100),
    `visit_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_ip` (`ip_address`),
    INDEX `idx_date` (`visit_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- API SETTINGS TABLE (Admin Panel için)
-- =====================================================
CREATE TABLE IF NOT EXISTS `api_settings` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `setting_key` VARCHAR(100) NOT NULL UNIQUE,
    `setting_value` LONGTEXT,
    `is_encrypted` TINYINT(1) DEFAULT 0,
    `description` VARCHAR(255),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- LOGIN ATTEMPTS TABLE (Brute-force Protection)
-- =====================================================
CREATE TABLE IF NOT EXISTS `login_attempts` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `ip_address` VARCHAR(45) NOT NULL,
    `username` VARCHAR(100),
    `attempted_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `success` TINYINT(1) DEFAULT 0,
    INDEX `idx_ip` (`ip_address`),
    INDEX `idx_time` (`attempted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- ADMIN SESSIONS TABLE (Session Hijacking Prevention)
-- =====================================================
CREATE TABLE IF NOT EXISTS `admin_sessions` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `admin_id` INT UNSIGNED NOT NULL,
    `session_id` VARCHAR(128) NOT NULL,
    `ip_address` VARCHAR(45) NOT NULL,
    `user_agent` VARCHAR(512),
    `remember_token` VARCHAR(64) NULL,
    `expires_at` DATETIME NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_session` (`session_id`),
    INDEX `idx_admin` (`admin_id`),
    INDEX `idx_token` (`remember_token`),
    FOREIGN KEY (`admin_id`) REFERENCES `admins`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- NETWORK LINKS TABLE (Domain Network Yönetimi)
-- =====================================================
CREATE TABLE IF NOT EXISTS `network_links` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `domain` VARCHAR(255) NOT NULL,
    `title` VARCHAR(255) NOT NULL,
    `anchor_text` VARCHAR(255),
    `target_url` VARCHAR(500),
    `rel_attribute` ENUM('dofollow', 'nofollow') DEFAULT 'dofollow',
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_domain` (`domain`),
    INDEX `idx_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default network links
INSERT INTO `network_links` (`domain`, `title`, `anchor_text`, `target_url`, `rel_attribute`, `display_order`) VALUES
('manisatenteci.com', 'Manisa Tente ve Pergola Sistemleri', 'Manisa Tenteci', 'https://manisatenteci.com', 'dofollow', 1),
('denizlitenteci.com', 'Denizli Tente ve Pergola Sistemleri', 'Denizli Tenteci', 'https://denizlitenteci.com', 'dofollow', 2),
('aydintenteci.com', 'Aydın Tente ve Pergola Sistemleri', 'Aydın Tenteci', 'https://aydintenteci.com', 'dofollow', 3),
('izmirotomatiktente.com', 'İzmir Otomatik Tente Sistemleri', 'İzmir Otomatik Tente', 'https://izmirotomatiktente.com', 'dofollow', 4),
('tenteci.net', 'Türkiye Tente ve Pergola Ağı', 'Tenteci.net', 'https://tenteci.net', 'dofollow', 5),
('tente.net', 'Tente Sistemleri Bilgi Portalı', 'Tente.net', 'https://tente.net', 'dofollow', 6),
('izmirpergola.net', 'İzmir Pergola Sistemleri', 'İzmir Pergola', 'https://izmirpergola.net', 'dofollow', 7);

-- =====================================================
-- ACTIVITY LOG TABLE (Admin Hareketleri)
-- =====================================================
CREATE TABLE IF NOT EXISTS `activity_log` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `admin_id` INT UNSIGNED,
    `action` VARCHAR(100) NOT NULL,
    `entity_type` VARCHAR(50),
    `entity_id` INT UNSIGNED,
    `description` TEXT,
    `ip_address` VARCHAR(45),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_admin` (`admin_id`),
    INDEX `idx_action` (`action`),
    INDEX `idx_created` (`created_at`),
    FOREIGN KEY (`admin_id`) REFERENCES `admins`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;
