-- =====================================================
-- AEGEAN DOMINANCE - YAPI DEKORASYON FİRMASI
-- Modern Database Schema
-- =====================================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+03:00";

CREATE DATABASE IF NOT EXISTS `dekorasyon` 
CHARACTER SET utf8mb4 COLLATE utf8mb4_turkish_ci;

USE `dekorasyon`;

-- =====================================================
-- ADMINS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `admins` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(50) NOT NULL UNIQUE,
    `password` VARCHAR(255) NOT NULL,
    `email` VARCHAR(100) NOT NULL,
    `full_name` VARCHAR(100) NOT NULL,
    `role` ENUM('admin', 'editor') DEFAULT 'admin',
    `is_active` TINYINT(1) DEFAULT 1,
    `last_login` DATETIME NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_username` (`username`),
    INDEX `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default admin (password: admin123)
INSERT INTO `admins` (`username`, `password`, `email`, `full_name`, `role`) VALUES
('admin', '$2y$10$CEorUqsAujBFie5cElkakeDhUZHFqpj0Fc2HhuYDNIVKQ8wRDMHam', 'info@yapidekorasyon.com', 'Site Yöneticisi', 'admin');

-- =====================================================
-- SETTINGS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `settings` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `setting_key` VARCHAR(100) NOT NULL UNIQUE,
    `setting_value` TEXT,
    `setting_type` ENUM('text', 'number', 'boolean', 'json') DEFAULT 'text',
    `category` VARCHAR(50) DEFAULT 'general',
    `description` VARCHAR(255),
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_category` (`category`),
    INDEX `idx_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_type`, `category`, `description`) VALUES
-- General
('site_name', 'Yapı Dekorasyon', 'text', 'general', 'Site adı'),
('site_slogan', 'Hayalinizdeki Mekanı Yaratıyoruz', 'text', 'general', 'Site sloganı'),
('site_description', 'Profesyonel İç Mekan Tasarımı, Tadilat ve Dekorasyon Hizmetleri', 'text', 'general', 'Site açıklaması'),
-- Contact
('contact_phone', '05362771709', 'text', 'contact', 'Telefon'),
('contact_phone_2', '05362771709', 'text', 'contact', 'Telefon 2'),
('contact_whatsapp', '905362771709', 'text', 'contact', 'WhatsApp'),
('contact_email', 'info@yapidekorasyon.com', 'text', 'contact', 'Email'),
('contact_address', 'İzmir, Türkiye', 'text', 'contact', 'Adres'),
('working_hours', 'Pazartesi - Cumartesi: 09:00 - 18:00', 'text', 'contact', 'Çalışma saatleri'),
-- Map
('map_latitude', '38.4192', 'text', 'map', 'Harita enlem'),
('map_longitude', '27.1287', 'text', 'map', 'Harita boylam'),
-- Social
('social_facebook', 'https://facebook.com/yapidekorasyon', 'text', 'social', 'Facebook'),
('social_instagram', 'https://instagram.com/yapidekorasyon', 'text', 'social', 'Instagram'),
('social_twitter', 'https://twitter.com/yapidekorasyon', 'text', 'social', 'Twitter'),
-- SEO
('seo_title', 'Yapı Dekorasyon | İç Mekan Tasarımı & Tadilat', 'text', 'seo', 'SEO başlık'),
('seo_description', 'Profesyonel iç mekan tasarımı, dekorasyon, tadilat ve yenileme hizmetleri. Hayalinizdeki mekanı birlikte tasarlayalım.', 'text', 'seo', 'SEO açıklama'),
('seo_keywords', 'iç mimarlık, dekorasyon, tadilat, yenileme, boya badana, alçıpan, laminat, mutfak yenileme', 'text', 'seo', 'SEO anahtar kelimeler');

-- =====================================================
-- SERVICES TABLE (Dekorasyon Hizmetleri)
-- =====================================================
CREATE TABLE IF NOT EXISTS `services` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(200) NOT NULL,
    `slug` VARCHAR(200) NOT NULL UNIQUE,
    `short_description` TEXT,
    `description` LONGTEXT,
    `features` JSON,
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `meta_keywords` VARCHAR(255),
    `featured_image` VARCHAR(500),
    `icon` VARCHAR(100) DEFAULT 'home',
    `category` VARCHAR(100),
    `price_range` VARCHAR(100) DEFAULT 'Projeye özel fiyatlandırma',
    `display_order` INT DEFAULT 0,
    `is_featured` TINYINT(1) DEFAULT 0,
    `is_active` TINYINT(1) DEFAULT 1,
    `view_count` INT UNSIGNED DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_category` (`category`),
    INDEX `idx_featured` (`is_featured`),
    INDEX `idx_order` (`display_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Yapı Dekorasyon Hizmetleri
INSERT INTO `services` (`name`, `slug`, `short_description`, `category`, `icon`, `display_order`, `is_featured`) VALUES
('İç Mekan Tasarımı', 'ic-mekan-tasarimi', 'Profesyonel iç mimar kadromuzla hayalinizdeki mekanı tasarlıyoruz. Modern ve fonksiyonel çözümler.', 'Tasarım', 'drafting-compass', 1, 1),
('Komple Tadilat', 'komple-tadilat', 'Evinizin veya işyerinizin komple tadilatı için anahtar teslim çözümler.', 'Tadilat', 'tools', 2, 1),
('Boya Badana', 'boya-badana', 'Kaliteli boya ve ustalarımızla profesyonel boya badana hizmetleri.', 'Boya İşleri', 'paint-roller', 3, 1),
('Alçıpan Asma Tavan', 'alcipan-asma-tavan', 'Modern alçıpan asma tavan sistemleri ve dekoratif tavan tasarımları.', 'Alçıpan', 'border-style', 4, 1),
('Alçıpan Bölme Duvar', 'alcipan-bolme-duvar', 'Mekanlarınızı yeniden şekillendirin. Ses yalıtımlı alçıpan bölme duvar sistemleri.', 'Alçıpan', 'table-columns', 5, 0),
('Laminat Parke', 'laminat-parke', 'Dayanıklı ve estetik laminat parke döşeme hizmetleri.', 'Zemin Kaplama', 'grip-lines', 6, 1),
('Masif Parke', 'masif-parke', 'Doğal ahşap masif parke döşeme ve bakım hizmetleri.', 'Zemin Kaplama', 'tree', 7, 0),
('Seramik ve Fayans', 'seramik-fayans', 'Banyo, mutfak ve zemin için profesyonel seramik fayans döşeme.', 'Zemin Kaplama', 'th-large', 8, 1),
('Mutfak Yenileme', 'mutfak-yenileme', 'Mutfak dolabı yenileme, tezgah değişimi ve komple mutfak tadilatı.', 'Mutfak', 'utensils', 9, 1),
('Banyo Yenileme', 'banyo-yenileme', 'Modern banyo tasarımı ve yenileme hizmetleri. Komple banyo tadilatı.', 'Banyo', 'bath', 10, 1),
('Mobilya İmalatı', 'mobilya-imalati', 'Özel tasarım mobilya imalatı. Gardırop, TV ünitesi, kitaplık ve daha fazlası.', 'Mobilya', 'couch', 11, 0),
('Spot ve Aydınlatma', 'spot-aydinlatma', 'Modern spot ve LED aydınlatma sistemleri kurulumu.', 'Elektrik', 'lightbulb', 12, 0),
('Elektrik Tesisatı', 'elektrik-tesisati', 'Elektrik tesisatı yenileme ve onarım hizmetleri.', 'Elektrik', 'bolt', 13, 0),
('Su Tesisatı', 'su-tesisati', 'Su tesisatı yenileme, onarım ve bakım hizmetleri.', 'Tesisat', 'droplet', 14, 0),
('Perde ve Fon Perde', 'perde-fon-perde', 'Özel dikim perde ve fon perde montajı. Stor perde sistemleri.', 'Dekorasyon', 'align-justify', 15, 0),
('Duvar Kağıdı', 'duvar-kagidi', 'Modern duvar kağıdı ve 3D duvar panel uygulamaları.', 'Dekorasyon', 'image', 16, 0),
('Kapı ve Pencere', 'kapi-pencere', 'Kapı ve pencere montajı, değişimi ve tamir hizmetleri.', 'Doğrama', 'door-open', 17, 0),
('Dekoratif Taş Kaplama', 'dekoratif-tas-kaplama', 'İç ve dış mekan dekoratif taş kaplama uygulamaları.', 'Dekorasyon', 'mountain', 18, 0);

-- =====================================================
-- SERVICE IMAGES TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `service_images` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `service_id` INT UNSIGNED NOT NULL,
    `image_path` VARCHAR(500) NOT NULL,
    `image_webp` VARCHAR(500),
    `alt_text` VARCHAR(255),
    `display_order` INT DEFAULT 0,
    `is_featured` TINYINT(1) DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_service` (`service_id`),
    INDEX `idx_order` (`display_order`),
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- CITIES TABLE (Multi-city landing pages)
-- =====================================================
CREATE TABLE IF NOT EXISTS `cities` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `slug` VARCHAR(100) NOT NULL UNIQUE,
    `region` VARCHAR(100) DEFAULT 'Ege',
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `content` LONGTEXT,
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_region` (`region`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Cities
INSERT INTO `cities` (`name`, `slug`, `region`, `display_order`) VALUES
('İzmir', 'izmir', 'Ege', 1),
('Manisa', 'manisa', 'Ege', 2),
('Aydın', 'aydin', 'Ege', 3),
('Denizli', 'denizli', 'Ege', 4),
('Muğla', 'mugla', 'Ege', 5);

-- =====================================================
-- TESTIMONIALS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `testimonials` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `customer_name` VARCHAR(100) NOT NULL,
    `customer_location` VARCHAR(100),
    `customer_image` VARCHAR(500),
    `content` TEXT NOT NULL,
    `rating` TINYINT UNSIGNED DEFAULT 5,
    `service_type` VARCHAR(100),
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_active` (`is_active`),
    INDEX `idx_rating` (`rating`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Sample testimonials
INSERT INTO `testimonials` (`customer_name`, `customer_location`, `content`, `rating`, `service_type`) VALUES
('Ahmet Yılmaz', 'İzmir, Karşıyaka', 'Evimizin komple tadilatını yaptırdık. Hem zamanında teslim ettiler hem de beklentilerimizin üzerinde bir iş çıkardılar. Çok memnun kaldık.', 5, 'Komple Tadilat'),
('Ayşe Kaya', 'İzmir, Bornova', 'Mutfak yenileme hizmetinden çok memnun kaldım. Profesyonel ekip ve kaliteli malzeme. Gönül rahatlığıyla tavsiye ediyorum.', 5, 'Mutfak Yenileme'),
('Mehmet Demir', 'İzmir, Konak', 'Salonumuza yaptırdığımız alçıpan asma tavan ve dekoratif taş kaplama harika oldu. Modern bir görünüm kazandı.', 5, 'Alçıpan Asma Tavan'),
('Fatma Özkan', 'İzmir, Alsancak', 'İç mekan tasarımından banyo yenilemeye kadar her şeyi baştan sona takip ettiler. Sonuçtan çok memnunuz.', 5, 'İç Mekan Tasarımı');

-- =====================================================
-- PROJECTS TABLE (Portfolio)
-- =====================================================
CREATE TABLE IF NOT EXISTS `projects` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `title` VARCHAR(200) NOT NULL,
    `slug` VARCHAR(200) NOT NULL UNIQUE,
    `description` TEXT,
    `location` VARCHAR(200),
    `service_id` INT UNSIGNED,
    `featured_image` VARCHAR(500),
    `completion_date` DATE,
    `is_featured` TINYINT(1) DEFAULT 0,
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_service` (`service_id`),
    FOREIGN KEY (`service_id`) REFERENCES `services`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- CONTACT FORMS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `contact_forms` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `form_type` ENUM('contact', 'quote') DEFAULT 'contact',
    `name` VARCHAR(100) NOT NULL,
    `email` VARCHAR(100),
    `phone` VARCHAR(20) NOT NULL,
    `service_type` VARCHAR(100),
    `message` TEXT,
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    `status` ENUM('new', 'read', 'replied', 'closed') DEFAULT 'new',
    `admin_note` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_status` (`status`),
    INDEX `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- BLOG POSTS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `blog_posts` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `title` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL UNIQUE,
    `excerpt` TEXT,
    `content` LONGTEXT,
    `featured_image` VARCHAR(500),
    `category` VARCHAR(100) DEFAULT 'Genel',
    `tags` VARCHAR(255),
    `meta_title` VARCHAR(255),
    `meta_description` TEXT,
    `author` VARCHAR(100) DEFAULT 'Yapı Dekorasyon',
    `status` ENUM('draft', 'published', 'scheduled') DEFAULT 'draft',
    `published_at` DATETIME,
    `view_count` INT UNSIGNED DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_slug` (`slug`),
    INDEX `idx_status` (`status`),
    INDEX `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- VISITORS TABLE
-- =====================================================
CREATE TABLE IF NOT EXISTS `visitors` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `ip_address` VARCHAR(45) NOT NULL,
    `user_agent` TEXT,
    `page_url` VARCHAR(500),
    `referrer` VARCHAR(500),
    `device_type` ENUM('Desktop', 'Mobile', 'Tablet', 'Bot') DEFAULT 'Desktop',
    `browser` VARCHAR(100),
    `country` VARCHAR(100),
    `city` VARCHAR(100),
    `visit_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_ip` (`ip_address`),
    INDEX `idx_date` (`visit_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- API SETTINGS TABLE (Admin Panel için)
-- =====================================================
CREATE TABLE IF NOT EXISTS `api_settings` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `setting_key` VARCHAR(100) NOT NULL UNIQUE,
    `setting_value` LONGTEXT,
    `is_encrypted` TINYINT(1) DEFAULT 0,
    `description` VARCHAR(255),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- LOGIN ATTEMPTS TABLE (Brute-force Protection)
-- =====================================================
CREATE TABLE IF NOT EXISTS `login_attempts` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `ip_address` VARCHAR(45) NOT NULL,
    `username` VARCHAR(100),
    `attempted_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `success` TINYINT(1) DEFAULT 0,
    INDEX `idx_ip` (`ip_address`),
    INDEX `idx_time` (`attempted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- ADMIN SESSIONS TABLE (Session Hijacking Prevention)
-- =====================================================
CREATE TABLE IF NOT EXISTS `admin_sessions` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `admin_id` INT UNSIGNED NOT NULL,
    `session_id` VARCHAR(128) NOT NULL,
    `ip_address` VARCHAR(45) NOT NULL,
    `user_agent` VARCHAR(512),
    `remember_token` VARCHAR(64) NULL,
    `expires_at` DATETIME NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_session` (`session_id`),
    INDEX `idx_admin` (`admin_id`),
    INDEX `idx_token` (`remember_token`),
    FOREIGN KEY (`admin_id`) REFERENCES `admins`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- =====================================================
-- NETWORK LINKS TABLE (Domain Network Yönetimi)
-- =====================================================
CREATE TABLE IF NOT EXISTS `network_links` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `domain` VARCHAR(255) NOT NULL,
    `title` VARCHAR(255) NOT NULL,
    `anchor_text` VARCHAR(255),
    `target_url` VARCHAR(500),
    `rel_attribute` ENUM('dofollow', 'nofollow') DEFAULT 'dofollow',
    `is_active` TINYINT(1) DEFAULT 1,
    `display_order` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_domain` (`domain`),
    INDEX `idx_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

-- Default network links (dekorasyon ağı için)
INSERT INTO `network_links` (`domain`, `title`, `anchor_text`, `target_url`, `rel_attribute`, `display_order`) VALUES
('izmirdekorasyon.com', 'İzmir Dekorasyon ve Tadilat', 'İzmir Dekorasyon', 'https://izmirdekorasyon.com', 'dofollow', 1),
('manisadekorasyon.com', 'Manisa Dekorasyon ve Tadilat', 'Manisa Dekorasyon', 'https://manisadekorasyon.com', 'dofollow', 2),
('denizlidekorasyon.com', 'Denizli Dekorasyon ve Tadilat', 'Denizli Dekorasyon', 'https://denizlidekorasyon.com', 'dofollow', 3);

-- =====================================================
-- ACTIVITY LOG TABLE (Admin Hareketleri)
-- =====================================================
CREATE TABLE IF NOT EXISTS `activity_log` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `admin_id` INT UNSIGNED,
    `action` VARCHAR(100) NOT NULL,
    `entity_type` VARCHAR(50),
    `entity_id` INT UNSIGNED,
    `description` TEXT,
    `ip_address` VARCHAR(45),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_admin` (`admin_id`),
    INDEX `idx_action` (`action`),
    INDEX `idx_created` (`created_at`),
    FOREIGN KEY (`admin_id`) REFERENCES `admins`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;
