<?php
/**
 * Database Setup Script - Fixed Version
 * Run this once to create tables and initial data
 */

echo "<!DOCTYPE html><html><head><title>DB Setup</title></head><body>";
echo "<h1>Aegean Dominance - Veritabanı Kurulumu</h1>";
echo "<pre style='background:#1a1a1a;color:#f3f4f6;padding:20px;border-radius:8px;'>";

// Database config
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'izmirtenteci_v2';

try {
    // Create database if not exists
    $pdo = new PDO("mysql:host={$host}", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$dbname}` CHARACTER SET utf8mb4 COLLATE utf8mb4_turkish_ci");
    echo "✅ Veritabanı oluşturuldu: {$dbname}\n\n";
    
    // Connect to database
    $pdo = new PDO("mysql:host={$host};dbname={$dbname};charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    // Create tables one by one
    echo "📦 Tablolar oluşturuluyor...\n\n";
    
    // 1. Admins
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `admins` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `username` VARCHAR(50) NOT NULL UNIQUE,
            `password` VARCHAR(255) NOT NULL,
            `email` VARCHAR(100) NOT NULL,
            `full_name` VARCHAR(100) NOT NULL,
            `role` ENUM('admin', 'editor') DEFAULT 'admin',
            `is_active` TINYINT(1) DEFAULT 1,
            `last_login` DATETIME NULL,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ admins tablosu oluşturuldu\n";
    
    // Insert default admin
    $pdo->exec("INSERT IGNORE INTO admins (username, password, email, full_name) VALUES 
        ('admin', '\$2y\$10\$CEorUqsAujBFie5cElkakeDhUZHFqpj0Fc2HhuYDNIVKQ8wRDMHam', 'info@izmirtenteci.com', 'Site Yöneticisi')");
    
    // 2. Settings
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `settings` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `setting_key` VARCHAR(100) NOT NULL UNIQUE,
            `setting_value` TEXT,
            `setting_type` ENUM('text', 'number', 'boolean', 'json') DEFAULT 'text',
            `category` VARCHAR(50) DEFAULT 'general',
            `description` VARCHAR(255),
            `is_active` TINYINT(1) DEFAULT 1,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ settings tablosu oluşturuldu\n";
    
    // Insert default settings - all categories
    $pdo->exec("INSERT IGNORE INTO settings (setting_key, setting_value, category, description) VALUES 
        ('site_name', 'İzmir Tenteci', 'general', 'Site adı'),
        ('site_slogan', 'Gölgeyi Tasarlıyoruz', 'general', 'Site sloganı'),
        ('contact_phone', '05362771709', 'contact', 'Telefon'),
        ('contact_whatsapp', '905362771709', 'contact', 'WhatsApp'),
        ('contact_email', 'info@izmirtenteci.com', 'contact', 'Email'),
        ('contact_address', 'Cennetoğlu, 5757. Sk. 22/C, 35110 Karabağlar/İzmir', 'contact', 'Adres'),
        ('social_facebook', 'https://facebook.com/izmirtenteci', 'social', 'Facebook'),
        ('social_instagram', 'https://instagram.com/izmirtenteci', 'social', 'Instagram'),
        ('map_lat', '38.3920', 'map', 'Harita Enlem'),
        ('map_lng', '27.0550', 'map', 'Harita Boylam'),
        ('map_zoom', '15', 'map', 'Harita Yakınlaştırma'),
        ('map_embed_url', 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3127.1!2d27.055!3d38.392', 'map', 'Google Maps Embed URL'),
        ('seo_title', 'İzmir Tenteci | Tente, Pergola ve Cam Balkon Sistemleri', 'seo', 'SEO Başlık'),
        ('seo_description', 'İzmir ve Ege Bölgesinde 35 yıllık tecrübe ile profesyonel tente, pergola ve cam balkon sistemleri.', 'seo', 'SEO Açıklama'),
        ('seo_keywords', 'izmir tente, pergola, bioklimatik pergola, cam balkon, zip perde', 'seo', 'SEO Anahtar Kelimeler'),
        ('google_analytics', '', 'seo', 'Google Analytics ID'),
        ('google_tag_manager', '', 'seo', 'Google Tag Manager ID')
    ");
    
    // 3. Services
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `services` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `name` VARCHAR(200) NOT NULL,
            `slug` VARCHAR(200) NOT NULL UNIQUE,
            `short_description` TEXT,
            `description` LONGTEXT,
            `icon` VARCHAR(100) DEFAULT 'umbrella',
            `category` VARCHAR(100),
            `display_order` INT DEFAULT 0,
            `is_featured` TINYINT(1) DEFAULT 0,
            `is_active` TINYINT(1) DEFAULT 1,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ services tablosu oluşturuldu\n";
    
    // Insert 18 services
    $pdo->exec("INSERT IGNORE INTO services (name, slug, short_description, category, icon, display_order, is_featured) VALUES 
        ('Bioklimatik Pergola', 'bioklimatik-pergola', 'Ayarlanabilir alüminyum lamellerle güneş, yağmur ve rüzgara karşı üstün koruma.', 'Pergola', 'sun', 1, 1),
        ('Pergola Tente', 'pergola-tente', 'Geniş alanlar için ideal, estetik ve dayanıklı pergola tente sistemleri.', 'Pergola', 'umbrella-beach', 2, 1),
        ('Askılı Pergola', 'askili-pergola', 'Duvara monte, kolonssuz şık pergola çözümleri.', 'Pergola', 'columns', 3, 0),
        ('Radyal Pergola', 'radyal-pergola', 'Yuvarlak ve kavisli tasarımlar için radyal pergola.', 'Pergola', 'circle', 4, 0),
        ('Çift Açılır Pergola', 'cift-acilir-pergola', 'Her iki yöne açılabilen esnek pergola sistemleri.', 'Pergola', 'arrows-left-right', 5, 0),
        ('Mafsallı Tente', 'mafsalli-tente', 'Balkon ve teraslar için motorlu veya manuel açılım seçenekleri.', 'Tente', 'store', 6, 1),
        ('Kasetli Tente', 'kasetli-tente', 'Kapalıyken tamamen korunaklı, uzun ömürlü premium tente.', 'Tente', 'box', 7, 0),
        ('Wintent Tente', 'wintent-tente', 'Kış aylarında da kullanılabilen dayanıklı tente sistemleri.', 'Tente', 'snowflake', 8, 0),
        ('Karpuz Tente', 'karpuz-tente', 'Şık görünümlü, dükkan ve cafe girişleri için karpuz tente.', 'Tente', 'shopping-bag', 9, 0),
        ('Zip Perde', 'zip-perde', 'Rüzgar ve yağmura karşı tam koruma sağlayan modern zip perde.', 'Perde', 'align-justify', 10, 1),
        ('Tavan Zip Perde', 'tavan-zip-perde', 'Tavan uygulamaları için özel zip perde çözümleri.', 'Perde', 'maximize', 11, 0),
        ('Cam Tavan Sistemleri', 'cam-tavan-sistemleri', 'Işık geçirgen, estetik cam tavan uygulamaları.', 'Cam', 'window-maximize', 12, 1),
        ('Giyotin Cam Sistemleri', 'giyotin-cam-sistemleri', 'Yukarı-aşağı açılan modern giyotin cam balkon.', 'Cam', 'th-large', 13, 0),
        ('Sürgülü Cam Balkon', 'surgulu-cam-balkon', 'Yatay sürgülü, esnek cam balkon kapatma sistemleri.', 'Cam', 'arrows-alt-h', 14, 1),
        ('Bombeli Askılı Pergola', 'bombeli-askili-pergola', 'Bombeli tasarımlı şık askılı pergola sistemleri.', 'Pergola', 'wave-square', 15, 0),
        ('Çift Açılır Askılı', 'cift-acilir-askili', 'Çift yönlü açılabilen askılı pergola tasarımları.', 'Pergola', 'swap', 16, 0),
        ('Radyal Çift Açılır', 'radyal-cift-acilir', 'Radyal tasarımlı çift açılır pergola sistemleri.', 'Pergola', 'rotate-cw', 17, 0),
        ('Rolling Roof', 'rolling-roof', 'Açılır kapanır çatı sistemleri, modern tasarım.', 'Pergola', 'home', 18, 0)
    ");
    echo "✅ 18 hizmet eklendi\n";
    
    // 4. Service Images
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `service_images` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `service_id` INT UNSIGNED NOT NULL,
            `image_path` VARCHAR(500) NOT NULL,
            `image_webp` VARCHAR(500),
            `alt_text` VARCHAR(255),
            `display_order` INT DEFAULT 0,
            `is_featured` TINYINT(1) DEFAULT 0,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ service_images tablosu oluşturuldu\n";
    
    // 5. Cities
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `cities` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `name` VARCHAR(100) NOT NULL,
            `slug` VARCHAR(100) NOT NULL UNIQUE,
            `region` VARCHAR(100) DEFAULT 'Ege',
            `is_active` TINYINT(1) DEFAULT 1,
            `display_order` INT DEFAULT 0,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ cities tablosu oluşturuldu\n";
    
    // Insert cities
    $pdo->exec("INSERT IGNORE INTO cities (name, slug, display_order) VALUES 
        ('İzmir', 'izmir', 1),
        ('Manisa', 'manisa', 2),
        ('Aydın', 'aydin', 3),
        ('Denizli', 'denizli', 4),
        ('Muğla', 'mugla', 5)
    ");
    
    // 6. Testimonials
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `testimonials` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `customer_name` VARCHAR(100) NOT NULL,
            `customer_location` VARCHAR(100),
            `content` TEXT NOT NULL,
            `rating` TINYINT UNSIGNED DEFAULT 5,
            `is_active` TINYINT(1) DEFAULT 1,
            `display_order` INT DEFAULT 0,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ testimonials tablosu oluşturuldu\n";
    
    // Insert testimonials
    $pdo->exec("INSERT IGNORE INTO testimonials (customer_name, customer_location, content, rating) VALUES 
        ('Ahmet Yılmaz', 'İzmir, Karşıyaka', 'Bioklimatik pergola sistemi terasımızı tamamen değiştirdi. Harika bir hizmet aldık.', 5),
        ('Ayşe Kaya', 'İzmir, Bornova', 'Profesyonel ekip, kaliteli malzeme ve zamanında teslimat. Tavsiye ediyorum.', 5),
        ('Mehmet Demir', 'İzmir, Konak', 'Zip perde sistemi kış aylarında bile terasımızı kullanmamızı sağladı.', 5),
        ('Fatma Özkan', 'İzmir, Alsancak', 'Cam balkon sistemimiz 3 yıldır sorunsuz çalışıyor. Servis ekibi de çok ilgili.', 5)
    ");
    
    // 7. Contact Forms
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `contact_forms` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `form_type` ENUM('contact', 'quote') DEFAULT 'contact',
            `name` VARCHAR(100) NOT NULL,
            `email` VARCHAR(100),
            `phone` VARCHAR(20) NOT NULL,
            `message` TEXT,
            `status` ENUM('new', 'read', 'replied', 'closed') DEFAULT 'new',
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ contact_forms tablosu oluşturuldu\n";
    
    // 8. Blog Posts
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS `blog_posts` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `title` VARCHAR(255) NOT NULL,
            `slug` VARCHAR(255) NOT NULL UNIQUE,
            `excerpt` TEXT,
            `content` LONGTEXT,
            `featured_image` VARCHAR(500),
            `category` VARCHAR(100) DEFAULT 'Genel',
            `status` ENUM('draft', 'published') DEFAULT 'draft',
            `view_count` INT UNSIGNED DEFAULT 0,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✅ blog_posts tablosu oluşturuldu\n";
    
    echo "\n📊 Tablo Özeti:\n";
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    foreach ($tables as $table) {
        $count = $pdo->query("SELECT COUNT(*) FROM `{$table}`")->fetchColumn();
        echo "   • {$table}: {$count} kayıt\n";
    }
    
    echo "\n✅ <strong>Kurulum tamamlandı!</strong>\n";
    
} catch (PDOException $e) {
    echo "❌ HATA: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><a href='../public/' style='color:#D4AF37;font-weight:bold;'>🏠 Ana Sayfaya Git →</a></p>";
echo "</body></html>";
?>
