<?php
/**
 * Admin Panel Database Setup
 * Sadece yeni tablolar için - mevcut veritabanına ekleme yapar
 */

require_once __DIR__ . '/../config/config.php';

echo "<h1>Admin Panel Veritabanı Kurulumu</h1>";
echo "<pre>";

$db = Database::getInstance();

try {
    // Admins tablosuna remember sütunları ekle
    echo "Updating admins table...\n";
    try {
        $db->execute("ALTER TABLE `admins` ADD COLUMN `remember_token` VARCHAR(64) NULL AFTER `last_login`");
        $db->execute("ALTER TABLE `admins` ADD COLUMN `remember_expires` DATETIME NULL AFTER `remember_token`");
        echo "✓ Remember columns added to admins\n";
    } catch (Exception $e) {
        echo "→ Remember columns may already exist\n";
    }
    
    // API Settings
    echo "Creating api_settings table...\n";
    $db->execute("
        CREATE TABLE IF NOT EXISTS `api_settings` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `setting_key` VARCHAR(100) NOT NULL UNIQUE,
            `setting_value` LONGTEXT,
            `is_encrypted` TINYINT(1) DEFAULT 0,
            `description` VARCHAR(255),
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX `idx_key` (`setting_key`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✓ api_settings created\n";
    
    // Login Attempts
    echo "Creating login_attempts table...\n";
    $db->execute("
        CREATE TABLE IF NOT EXISTS `login_attempts` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `ip_address` VARCHAR(45) NOT NULL,
            `username` VARCHAR(100),
            `attempted_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `success` TINYINT(1) DEFAULT 0,
            INDEX `idx_ip` (`ip_address`),
            INDEX `idx_time` (`attempted_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✓ login_attempts created\n";
    
    // Admin Sessions
    echo "Creating admin_sessions table...\n";
    $db->execute("
        CREATE TABLE IF NOT EXISTS `admin_sessions` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `admin_id` INT UNSIGNED NOT NULL,
            `session_id` VARCHAR(128) NOT NULL,
            `ip_address` VARCHAR(45) NOT NULL,
            `user_agent` VARCHAR(512),
            `remember_token` VARCHAR(64) NULL,
            `expires_at` DATETIME NOT NULL,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX `idx_session` (`session_id`),
            INDEX `idx_admin` (`admin_id`),
            INDEX `idx_token` (`remember_token`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✓ admin_sessions created\n";
    
    // Network Links
    echo "Creating network_links table...\n";
    $db->execute("
        CREATE TABLE IF NOT EXISTS `network_links` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `domain` VARCHAR(255) NOT NULL,
            `title` VARCHAR(255) NOT NULL,
            `anchor_text` VARCHAR(255),
            `target_url` VARCHAR(500),
            `rel_attribute` ENUM('dofollow', 'nofollow') DEFAULT 'dofollow',
            `is_active` TINYINT(1) DEFAULT 1,
            `display_order` INT DEFAULT 0,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX `idx_domain` (`domain`),
            INDEX `idx_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✓ network_links created\n";
    
    // Default network links
    $existing = $db->fetchColumn("SELECT COUNT(*) FROM network_links");
    if ($existing == 0) {
        echo "Inserting default network links...\n";
        $links = [
            ['manisatenteci.com', 'Manisa Tente ve Pergola Sistemleri', 'Manisa Tenteci', 'https://manisatenteci.com', 'dofollow', 1],
            ['denizlitenteci.com', 'Denizli Tente ve Pergola Sistemleri', 'Denizli Tenteci', 'https://denizlitenteci.com', 'dofollow', 2],
            ['aydintenteci.com', 'Aydın Tente ve Pergola Sistemleri', 'Aydın Tenteci', 'https://aydintenteci.com', 'dofollow', 3],
            ['izmirotomatiktente.com', 'İzmir Otomatik Tente Sistemleri', 'İzmir Otomatik Tente', 'https://izmirotomatiktente.com', 'dofollow', 4],
            ['tenteci.net', 'Türkiye Tente ve Pergola Ağı', 'Tenteci.net', 'https://tenteci.net', 'dofollow', 5],
            ['tente.net', 'Tente Sistemleri Bilgi Portalı', 'Tente.net', 'https://tente.net', 'dofollow', 6],
            ['izmirpergola.net', 'İzmir Pergola Sistemleri', 'İzmir Pergola', 'https://izmirpergola.net', 'dofollow', 7]
        ];
        
        foreach ($links as $link) {
            $db->execute(
                "INSERT INTO network_links (domain, title, anchor_text, target_url, rel_attribute, display_order) VALUES (?, ?, ?, ?, ?, ?)",
                $link
            );
        }
        echo "✓ Default network links inserted\n";
    }
    
    // Activity Log
    echo "Creating activity_log table...\n";
    $db->execute("
        CREATE TABLE IF NOT EXISTS `activity_log` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `admin_id` INT UNSIGNED,
            `action` VARCHAR(100) NOT NULL,
            `entity_type` VARCHAR(50),
            `entity_id` INT UNSIGNED,
            `description` TEXT,
            `ip_address` VARCHAR(45),
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX `idx_admin` (`admin_id`),
            INDEX `idx_action` (`action`),
            INDEX `idx_created` (`created_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci
    ");
    echo "✓ activity_log created\n";
    
    echo "\n=================================\n";
    echo "Admin Panel veritabanı kurulumu tamamlandı!\n";
    echo "=================================\n";
    echo "\n<a href='../admin/login.php'>Admin Paneline Git →</a>\n";
    
} catch (Exception $e) {
    echo "HATA: " . $e->getMessage() . "\n";
}

echo "</pre>";
