<?php
/**
 * Dekorasyon Veritabanı Kurulum Scripti
 * Bu script yeni "dekorasyon" veritabanını oluşturur
 */

// Config dosyasını yükle
require_once __DIR__ . '/../config/config.php';

try {
    // İlk olarak veritabanı olmadan bağlan
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET,
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    echo "✓ MySQL bağlantısı başarılı\n\n";

    // Schema dosyasını oku ve çalıştır
    $schemaFile = __DIR__ . '/schema_dekorasyon.sql';
    
    if (!file_exists($schemaFile)) {
        throw new Exception("Schema dosyası bulunamadı: {$schemaFile}");
    }

    $sql = file_get_contents($schemaFile);
    
    // SQL komutlarını ayır ve çalıştır
    $statements = array_filter(
        array_map('trim', explode(';', $sql)),
        function($stmt) {
            return !empty($stmt) && 
                   !preg_match('/^(--|\s*$)/', $stmt);
        }
    );

    echo "SQL komutları çalıştırılıyor...\n\n";
    
    $successCount = 0;
    $errorCount = 0;

    foreach ($statements as $statement) {
        try {
            $pdo->exec($statement);
            $successCount++;
            
            // İlerleme göster
            if (stripos($statement, 'CREATE TABLE') !== false) {
                preg_match('/CREATE TABLE.*?`([^`]+)`/i', $statement, $matches);
                if (isset($matches[1])) {
                    echo "  ✓ Tablo oluşturuldu: {$matches[1]}\n";
                }
            } elseif (stripos($statement, 'INSERT INTO') !== false) {
                preg_match('/INSERT INTO.*?`([^`]+)`/i', $statement, $matches);
                if (isset($matches[1])) {
                    echo "  ✓ Veri eklendi: {$matches[1]}\n";
                }
            } elseif (stripos($statement, 'CREATE DATABASE') !== false) {
                echo "  ✓ Veritabanı oluşturuldu: dekorasyon\n";
            }
        } catch (PDOException $e) {
            $errorCount++;
            // Duplicate veritabanı/tablo hatalarını görmezden gel
            if (strpos($e->getMessage(), 'already exists') === false) {
                echo "  ✗ Hata: " . $e->getMessage() . "\n";
            }
        }
    }

    echo "\n" . str_repeat("=", 60) . "\n";
    echo "KURULUM TAMAMLANDI!\n";
    echo str_repeat("=", 60) . "\n\n";
    
    echo "Başarılı: {$successCount} komut\n";
    if ($errorCount > 0) {
        echo "Hata: {$errorCount} komut\n";
    }
    
    echo "\n📊 Oluşturulan Tablolar:\n";
    echo "  • admins (yönetici hesapları)\n";
    echo "  • settings (site ayarları)\n";
    echo "  • services (18 dekorasyon hizmeti)\n";
    echo "  • service_images (hizmet görselleri)\n";
    echo "  • cities (şehir sayfaları)\n";
    echo "  • testimonials (müşteri yorumları)\n";
    echo "  • projects (portfolyo)\n";
    echo "  • contact_forms (iletişim formları)\n";
    echo "  • blog_posts (blog yazıları)\n";
    echo "  • visitors (ziyaretçi analizi)\n";
    echo "  • api_settings (API ayarları)\n";
    echo "  • login_attempts (güvenlik)\n";
    echo "  • admin_sessions (oturum yönetimi)\n";
    echo "  • network_links (domain ağı)\n";
    echo "  • activity_log (admin hareketleri)\n";

    echo "\n🔐 Varsayılan Admin Hesabı:\n";
    echo "  Kullanıcı Adı: admin\n";
    echo "  Şifre: admin123\n";
    echo "  Email: info@yapidekorasyon.com\n";

    echo "\n✨ Sisteme /admin üzerinden giriş yapabilirsiniz.\n\n";

} catch (PDOException $e) {
    echo "\n❌ HATA: Veritabanı bağlantısı başarısız!\n";
    echo "Detay: " . $e->getMessage() . "\n\n";
    exit(1);
} catch (Exception $e) {
    echo "\n❌ HATA: " . $e->getMessage() . "\n\n";
    exit(1);
}
