-- Database Dump: dekorasyon
-- Date: 2025-12-26 11:35:44

SET FOREIGN_KEY_CHECKS=0;



CREATE TABLE `activity_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int unsigned DEFAULT NULL,
  `action` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `entity_type` varchar(50) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `entity_id` int unsigned DEFAULT NULL,
  `description` text COLLATE utf8mb4_turkish_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_admin` (`admin_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created` (`created_at`),
  CONSTRAINT `activity_log_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `admin_sessions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int unsigned NOT NULL,
  `session_id` varchar(128) COLLATE utf8mb4_turkish_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_turkish_ci NOT NULL,
  `user_agent` varchar(512) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `remember_token` varchar(64) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_session` (`session_id`),
  KEY `idx_admin` (`admin_id`),
  KEY `idx_token` (`remember_token`),
  CONSTRAINT `admin_sessions_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `admin_sessions` VALUES ('1','1','c1bc27aa162592a8892cc1fb41b0f59ef9449a4f0bff6f412628fef3db40c566','::1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36',NULL,'2025-12-25 14:24:20','2025-12-25 13:24:20');


CREATE TABLE `admins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) COLLATE utf8mb4_turkish_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `full_name` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `role` enum('admin','editor') COLLATE utf8mb4_turkish_ci DEFAULT 'admin',
  `is_active` tinyint(1) DEFAULT '1',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `admins` VALUES ('1','admin','$2y$10$CEorUqsAujBFie5cElkakeDhUZHFqpj0Fc2HhuYDNIVKQ8wRDMHam','info@yapidekorasyon.com','Site Yöneticisi','admin','1','2025-12-25 13:24:20','2025-12-25 11:49:39','2025-12-25 13:24:20');


CREATE TABLE `api_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `setting_value` longtext COLLATE utf8mb4_turkish_ci,
  `is_encrypted` tinyint(1) DEFAULT '0',
  `description` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`),
  KEY `idx_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `blog_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `excerpt` text COLLATE utf8mb4_turkish_ci,
  `content` longtext COLLATE utf8mb4_turkish_ci,
  `featured_image` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `category` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT 'Genel',
  `tags` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_turkish_ci,
  `author` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT 'Yapı Dekorasyon',
  `status` enum('draft','published','scheduled') COLLATE utf8mb4_turkish_ci DEFAULT 'draft',
  `published_at` datetime DEFAULT NULL,
  `view_count` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `idx_slug` (`slug`),
  KEY `idx_status` (`status`),
  KEY `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `cities` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `slug` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `region` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT 'Ege',
  `meta_title` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_turkish_ci,
  `content` longtext COLLATE utf8mb4_turkish_ci,
  `is_active` tinyint(1) DEFAULT '1',
  `display_order` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `idx_slug` (`slug`),
  KEY `idx_region` (`region`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `cities` VALUES ('1','İzmir','izmir','Ege',NULL,NULL,NULL,'1','1','2025-12-25 11:49:39'),('2','Manisa','manisa','Ege',NULL,NULL,NULL,'1','2','2025-12-25 11:49:39'),('3','Aydın','aydin','Ege',NULL,NULL,NULL,'1','3','2025-12-25 11:49:39'),('4','Denizli','denizli','Ege',NULL,NULL,NULL,'1','4','2025-12-25 11:49:39'),('5','Muğla','mugla','Ege',NULL,NULL,NULL,'1','5','2025-12-25 11:49:39');


CREATE TABLE `contact_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_type` enum('contact','quote') COLLATE utf8mb4_turkish_ci DEFAULT 'contact',
  `name` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_turkish_ci NOT NULL,
  `service_type` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_turkish_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_turkish_ci,
  `status` enum('new','read','replied','closed') COLLATE utf8mb4_turkish_ci DEFAULT 'new',
  `admin_note` text COLLATE utf8mb4_turkish_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `login_attempts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) COLLATE utf8mb4_turkish_ci NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `attempted_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `success` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ip` (`ip_address`),
  KEY `idx_time` (`attempted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `network_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `anchor_text` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `target_url` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `rel_attribute` enum('dofollow','nofollow') COLLATE utf8mb4_turkish_ci DEFAULT 'dofollow',
  `is_active` tinyint(1) DEFAULT '1',
  `display_order` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_domain` (`domain`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `network_links` VALUES ('1','izmirdekorasyon.com','İzmir Dekorasyon ve Tadilat','İzmir Dekorasyon','https://izmirdekorasyon.com','dofollow','1','1','2025-12-25 11:49:40','2025-12-25 11:49:40'),('2','manisadekorasyon.com','Manisa Dekorasyon ve Tadilat','Manisa Dekorasyon','https://manisadekorasyon.com','dofollow','1','2','2025-12-25 11:49:40','2025-12-25 11:49:40'),('3','denizlidekorasyon.com','Denizli Dekorasyon ve Tadilat','Denizli Dekorasyon','https://denizlidekorasyon.com','dofollow','1','3','2025-12-25 11:49:40','2025-12-25 11:49:40');


CREATE TABLE `projects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_turkish_ci NOT NULL,
  `slug` varchar(200) COLLATE utf8mb4_turkish_ci NOT NULL,
  `description` text COLLATE utf8mb4_turkish_ci,
  `location` varchar(200) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `service_id` int unsigned DEFAULT NULL,
  `featured_image` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `completion_date` date DEFAULT NULL,
  `is_featured` tinyint(1) DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `idx_slug` (`slug`),
  KEY `idx_service` (`service_id`),
  CONSTRAINT `projects_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `service_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `service_id` int unsigned NOT NULL,
  `image_path` varchar(500) COLLATE utf8mb4_turkish_ci NOT NULL,
  `image_webp` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `alt_text` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `display_order` int DEFAULT '0',
  `is_featured` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_service` (`service_id`),
  KEY `idx_order` (`display_order`),
  CONSTRAINT `service_images_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



CREATE TABLE `services` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_turkish_ci NOT NULL,
  `slug` varchar(200) COLLATE utf8mb4_turkish_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_turkish_ci,
  `description` longtext COLLATE utf8mb4_turkish_ci,
  `features` json DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_turkish_ci,
  `meta_keywords` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `featured_image` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `icon` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT 'home',
  `category` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `price_range` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT 'Projeye özel fiyatlandırma',
  `display_order` int DEFAULT '0',
  `is_featured` tinyint(1) DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `view_count` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `idx_slug` (`slug`),
  KEY `idx_category` (`category`),
  KEY `idx_featured` (`is_featured`),
  KEY `idx_order` (`display_order`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `services` VALUES ('1','İç Mekan Tasarımı','ic-mekan-tasarimi','Profesyonel iç mimar kadromuzla hayalinizdeki mekanı tasarlıyoruz. Modern ve fonksiyonel çözümler.',NULL,NULL,NULL,NULL,NULL,NULL,'drafting-compass','Tasarım','Projeye özel fiyatlandırma','1','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('2','Komple Tadilat','komple-tadilat','Evinizin veya işyerinizin komple tadilatı için anahtar teslim çözümler.',NULL,NULL,NULL,NULL,NULL,NULL,'tools','Tadilat','Projeye özel fiyatlandırma','2','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('3','Boya Badana','boya-badana','Kaliteli boya ve ustalarımızla profesyonel boya badana hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'paint-roller','Boya İşleri','Projeye özel fiyatlandırma','3','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('4','Alçıpan Asma Tavan','alcipan-asma-tavan','Modern alçıpan asma tavan sistemleri ve dekoratif tavan tasarımları.',NULL,NULL,NULL,NULL,NULL,NULL,'border-style','Alçıpan','Projeye özel fiyatlandırma','4','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('5','Alçıpan Bölme Duvar','alcipan-bolme-duvar','Mekanlarınızı yeniden şekillendirin. Ses yalıtımlı alçıpan bölme duvar sistemleri.',NULL,NULL,NULL,NULL,NULL,NULL,'table-columns','Alçıpan','Projeye özel fiyatlandırma','5','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('6','Laminat Parke','laminat-parke','Dayanıklı ve estetik laminat parke döşeme hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'grip-lines','Zemin Kaplama','Projeye özel fiyatlandırma','6','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('7','Masif Parke','masif-parke','Doğal ahşap masif parke döşeme ve bakım hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'tree','Zemin Kaplama','Projeye özel fiyatlandırma','7','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('8','Seramik ve Fayans','seramik-fayans','Banyo, mutfak ve zemin için profesyonel seramik fayans döşeme.',NULL,NULL,NULL,NULL,NULL,NULL,'th-large','Zemin Kaplama','Projeye özel fiyatlandırma','8','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('9','Mutfak Yenileme','mutfak-yenileme','Mutfak dolabı yenileme, tezgah değişimi ve komple mutfak tadilatı.',NULL,NULL,NULL,NULL,NULL,NULL,'utensils','Mutfak','Projeye özel fiyatlandırma','9','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('10','Banyo Yenileme','banyo-yenileme','Modern banyo tasarımı ve yenileme hizmetleri. Komple banyo tadilatı.',NULL,NULL,NULL,NULL,NULL,NULL,'bath','Banyo','Projeye özel fiyatlandırma','10','1','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('11','Mobilya İmalatı','mobilya-imalati','Özel tasarım mobilya imalatı. Gardırop, TV ünitesi, kitaplık ve daha fazlası.',NULL,NULL,NULL,NULL,NULL,NULL,'couch','Mobilya','Projeye özel fiyatlandırma','11','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('12','Spot ve Aydınlatma','spot-aydinlatma','Modern spot ve LED aydınlatma sistemleri kurulumu.',NULL,NULL,NULL,NULL,NULL,NULL,'lightbulb','Elektrik','Projeye özel fiyatlandırma','12','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('13','Elektrik Tesisatı','elektrik-tesisati','Elektrik tesisatı yenileme ve onarım hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'bolt','Elektrik','Projeye özel fiyatlandırma','13','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('14','Su Tesisatı','su-tesisati','Su tesisatı yenileme, onarım ve bakım hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'droplet','Tesisat','Projeye özel fiyatlandırma','14','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('15','Perde ve Fon Perde','perde-fon-perde','Özel dikim perde ve fon perde montajı. Stor perde sistemleri.',NULL,NULL,NULL,NULL,NULL,NULL,'align-justify','Dekorasyon','Projeye özel fiyatlandırma','15','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('16','Duvar Kağıdı','duvar-kagidi','Modern duvar kağıdı ve 3D duvar panel uygulamaları.',NULL,NULL,NULL,NULL,NULL,NULL,'image','Dekorasyon','Projeye özel fiyatlandırma','16','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('17','Kapı ve Pencere','kapi-pencere','Kapı ve pencere montajı, değişimi ve tamir hizmetleri.',NULL,NULL,NULL,NULL,NULL,NULL,'door-open','Doğrama','Projeye özel fiyatlandırma','17','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39'),('18','Dekoratif Taş Kaplama','dekoratif-tas-kaplama','İç ve dış mekan dekoratif taş kaplama uygulamaları.',NULL,NULL,NULL,NULL,NULL,NULL,'mountain','Dekorasyon','Projeye özel fiyatlandırma','18','0','1','0','2025-12-25 11:49:39','2025-12-25 11:49:39');


CREATE TABLE `settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `setting_value` text COLLATE utf8mb4_turkish_ci,
  `setting_type` enum('text','number','boolean','json') COLLATE utf8mb4_turkish_ci DEFAULT 'text',
  `category` varchar(50) COLLATE utf8mb4_turkish_ci DEFAULT 'general',
  `description` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`),
  KEY `idx_category` (`category`),
  KEY `idx_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `settings` VALUES ('1','site_name','Yapı Dekorasyon','text','general','Site adı','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('2','site_slogan','Hayalinizdeki Mekanı Yaratıyoruz','text','general','Site sloganı','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('3','site_description','Profesyonel İç Mekan Tasarımı, Tadilat ve Dekorasyon Hizmetleri','text','general','Site açıklaması','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('4','contact_phone','05362771709','text','contact','Telefon','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('5','contact_phone_2','05362771709','text','contact','Telefon 2','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('6','contact_whatsapp','905362771709','text','contact','WhatsApp','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('7','contact_email','info@yapidekorasyon.com','text','contact','Email','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('8','contact_address','İzmir, Türkiye','text','contact','Adres','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('9','working_hours','Pazartesi - Cumartesi: 09:00 - 18:00','text','contact','Çalışma saatleri','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('10','map_latitude','38.4192','text','map','Harita enlem','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('11','map_longitude','27.1287','text','map','Harita boylam','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('12','social_facebook','https://facebook.com/yapidekorasyon','text','social','Facebook','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('13','social_instagram','https://instagram.com/yapidekorasyon','text','social','Instagram','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('14','social_twitter','https://twitter.com/yapidekorasyon','text','social','Twitter','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('15','seo_title','Yapı Dekorasyon | İç Mekan Tasarımı & Tadilat','text','seo','SEO başlık','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('16','seo_description','Profesyonel iç mekan tasarımı, dekorasyon, tadilat ve yenileme hizmetleri. Hayalinizdeki mekanı birlikte tasarlayalım.','text','seo','SEO açıklama','1','2025-12-25 11:49:39','2025-12-25 11:49:39'),('17','seo_keywords','iç mimarlık, dekorasyon, tadilat, yenileme, boya badana, alçıpan, laminat, mutfak yenileme','text','seo','SEO anahtar kelimeler','1','2025-12-25 11:49:39','2025-12-25 11:49:39');


CREATE TABLE `testimonials` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `customer_location` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `customer_image` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_turkish_ci NOT NULL,
  `rating` tinyint unsigned DEFAULT '5',
  `service_type` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `display_order` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_active` (`is_active`),
  KEY `idx_rating` (`rating`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;

INSERT INTO `testimonials` VALUES ('1','Ahmet Yılmaz','İzmir, Karşıyaka',NULL,'Evimizin komple tadilatını yaptırdık. Hem zamanında teslim ettiler hem de beklentilerimizin üzerinde bir iş çıkardılar. Çok memnun kaldık.','5','Komple Tadilat','1','0','2025-12-25 11:49:39'),('2','Ayşe Kaya','İzmir, Bornova',NULL,'Mutfak yenileme hizmetinden çok memnun kaldım. Profesyonel ekip ve kaliteli malzeme. Gönül rahatlığıyla tavsiye ediyorum.','5','Mutfak Yenileme','1','0','2025-12-25 11:49:39'),('3','Mehmet Demir','İzmir, Konak',NULL,'Salonumuza yaptırdığımız alçıpan asma tavan ve dekoratif taş kaplama harika oldu. Modern bir görünüm kazandı.','5','Alçıpan Asma Tavan','1','0','2025-12-25 11:49:39'),('4','Fatma Özkan','İzmir, Alsancak',NULL,'İç mekan tasarımından banyo yenilemeye kadar her şeyi baştan sona takip ettiler. Sonuçtan çok memnunuz.','5','İç Mekan Tasarımı','1','0','2025-12-25 11:49:39');


CREATE TABLE `visitors` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) COLLATE utf8mb4_turkish_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_turkish_ci,
  `page_url` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `referrer` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `device_type` enum('Desktop','Mobile','Tablet','Bot') COLLATE utf8mb4_turkish_ci DEFAULT 'Desktop',
  `browser` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `visit_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_ip` (`ip_address`),
  KEY `idx_date` (`visit_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;



SET FOREIGN_KEY_CHECKS=1;
