<?php
/**
 * Dynamic XML Sitemap Generator
 * Yapı Dekorasyon V2
 * 
 * Tüm sayfaları ve hizmetleri dinamik olarak listeler
 */

require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/xml; charset=utf-8');

$baseUrl = defined('BASE_URL') ? BASE_URL : 'https://yapidekorasyon.com';
$today = date('Y-m-d');

// Static pages
$staticPages = [
    ['url' => '/', 'priority' => '1.0', 'changefreq' => 'daily'],
    ['url' => '/hizmetlerimiz', 'priority' => '0.9', 'changefreq' => 'weekly'],
    ['url' => '/hakkimizda', 'priority' => '0.7', 'changefreq' => 'monthly'],
    ['url' => '/iletisim', 'priority' => '0.8', 'changefreq' => 'monthly'],
    ['url' => '/galeri', 'priority' => '0.7', 'changefreq' => 'weekly'],
    ['url' => '/referanslar', 'priority' => '0.6', 'changefreq' => 'monthly'],
    ['url' => '/teklif-al', 'priority' => '0.9', 'changefreq' => 'monthly'],
];

// Get services from database (only slug, no updated_at)
$services = db()->fetchAll(
    "SELECT slug FROM services WHERE is_active = 1 ORDER BY display_order"
);

// Get cities from database
$cities = db()->fetchAll(
    "SELECT slug FROM cities WHERE is_active = 1 ORDER BY display_order"
);

// Get blog posts from database
$posts = db()->fetchAll(
    "SELECT slug, created_at FROM blog_posts WHERE status = 'published' ORDER BY created_at DESC LIMIT 100"
);

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>

<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
        http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
    
    <!-- Static Pages -->
<?php foreach ($staticPages as $page): ?>
    <url>
        <loc><?= $baseUrl . $page['url'] ?></loc>
        <lastmod><?= $today ?></lastmod>
        <changefreq><?= $page['changefreq'] ?></changefreq>
        <priority><?= $page['priority'] ?></priority>
    </url>
<?php endforeach; ?>
    
    <!-- Services / Hizmetler -->
<?php foreach ($services as $service): ?>
    <url>
        <loc><?= $baseUrl ?>/hizmetlerimiz/<?= $service['slug'] ?></loc>
        <lastmod><?= $today ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
<?php endforeach; ?>
    
    <!-- City Landing Pages -->
<?php foreach ($cities as $city): ?>
    <url>
        <loc><?= $baseUrl ?>/<?= $city['slug'] ?>-tadilat</loc>
        <lastmod><?= $today ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>
<?php endforeach; ?>
    
    <!-- Blog Posts -->
<?php foreach ($posts as $post): ?>
    <url>
        <loc><?= $baseUrl ?>/blog/<?= $post['slug'] ?></loc>
        <lastmod><?= date('Y-m-d', strtotime($post['created_at'] ?? $today)) ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
<?php endforeach; ?>

</urlset>
