<?php
/**
 * 404 Sayfası
 * İzmir Tenteci V2
 */

$pageTitle = '404 - Sayfa Bulunamadı | İzmir Tenteci';
$pageDescription = 'Aradığınız sayfa bulunamadı.';

ob_start();
?>

<section class="min-h-[70vh] flex items-center justify-center py-20 bg-dark">
    <div class="container mx-auto px-4 text-center">
        <!-- 404 Number -->
        <div class="text-9xl font-heading font-bold text-gradient-gold mb-8">404</div>
        
        <h1 class="text-3xl md:text-4xl font-heading font-bold text-white mb-4">
            Sayfa Bulunamadı
        </h1>
        
        <p class="text-gray-400 text-lg mb-8 max-w-xl mx-auto">
            Aradığınız sayfa mevcut değil veya taşınmış olabilir. 
            Ana sayfaya dönerek arama yapabilirsiniz.
        </p>
        
        <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
            <a href="<?= Router::url('/') ?>" class="btn-gold px-8 py-4 rounded-lg text-dark font-bold flex items-center gap-2">
                <i data-lucide="home" class="w-5 h-5"></i>
                Ana Sayfa
            </a>
            <a href="<?= Router::url('/hizmetlerimiz') ?>" class="px-8 py-4 rounded-lg border border-gold/50 text-gold font-bold hover:bg-gold/10 transition-all flex items-center gap-2">
                <i data-lucide="grid-3x3" class="w-5 h-5"></i>
                Hizmetlerimiz
            </a>
        </div>
        
        <!-- İletişim -->
        <div class="mt-12 pt-8 border-t border-dark-border">
            <p class="text-gray-500 mb-4">Yardıma mı ihtiyacınız var?</p>
            <a href="tel:<?= setting('contact_phone', SITE_PHONE) ?>" class="text-gold hover:text-gold-light font-semibold">
                <i data-lucide="phone" class="w-4 h-4 inline mr-2"></i>
                <?= setting('contact_phone', SITE_PHONE) ?>
            </a>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
