<?php
/**
 * Hakkımızda Sayfası
 * İzmir Tenteci V2
 */

$pageTitle = 'Hakkımızda | İzmir Tenteci';
$pageDescription = '1990\'dan bu yana İzmir ve Ege Bölgesi\'nde 35 yıllık tecrübe ile tente, pergola ve cam balkon sistemleri.';

ob_start();
?>

<!-- Hero -->
<section class="py-20 bg-gradient-to-b from-dark-card to-dark">
    <div class="container mx-auto px-4 text-center">
        <span class="inline-block text-gold text-sm font-semibold tracking-wider uppercase mb-4">HAKKIMIZDA</span>
        <h1 class="text-4xl md:text-5xl font-heading font-bold text-white mb-6">
            35 Yıllık Tecrübe ve Güven
        </h1>
        <p class="text-xl text-gray-400 max-w-3xl mx-auto">
            1990 yılından bu yana İzmir ve Ege Bölgesi'nde binlerce projeye imza attık.
        </p>
    </div>
</section>

<!-- Hikayemiz -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <span class="text-gold text-sm font-semibold uppercase mb-4 block">HİKAYEMİZ</span>
                <h2 class="text-3xl font-heading font-bold text-white mb-6">
                    Ege'nin Gölgelendirme Ustası
                </h2>
                <div class="space-y-4 text-gray-400">
                    <p>
                        İzmir Tenteci olarak 1990 yılında küçük bir atölyede başladığımız yolculuğumuz, 
                        bugün Ege Bölgesi'nin en güvenilir tente ve pergola markalarından biri haline geldi.
                    </p>
                    <p>
                        35 yıllık tecrübemizle 2000'den fazla projeyi başarıyla tamamladık. 
                        Her projemizde kaliteli malzeme, profesyonel işçilik ve müşteri memnuniyetini ön planda tuttuk.
                    </p>
                    <p>
                        Tente.net ağının bir üyesi olarak İzmir, Manisa, Aydın, Denizli ve Muğla'da 
                        hizmet vermeye devam ediyoruz.
                    </p>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-4">
                <div class="card-dark rounded-2xl p-6 text-center">
                    <div class="text-4xl font-heading font-bold text-gold mb-2">35</div>
                    <div class="text-gray-400">Yıllık Tecrübe</div>
                </div>
                <div class="card-dark rounded-2xl p-6 text-center">
                    <div class="text-4xl font-heading font-bold text-gold mb-2">2000+</div>
                    <div class="text-gray-400">Proje</div>
                </div>
                <div class="card-dark rounded-2xl p-6 text-center">
                    <div class="text-4xl font-heading font-bold text-gold mb-2">1500+</div>
                    <div class="text-gray-400">Mutlu Müşteri</div>
                </div>
                <div class="card-dark rounded-2xl p-6 text-center">
                    <div class="text-4xl font-heading font-bold text-gold mb-2">5</div>
                    <div class="text-gray-400">Şehir</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Değerlerimiz -->
<section class="py-20 bg-dark-card">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="text-gold text-sm font-semibold uppercase mb-4 block">DEĞERLERİMİZ</span>
            <h2 class="text-3xl font-heading font-bold text-white">Neden Bizi Tercih Etmelisiniz?</h2>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="text-center p-6">
                <div class="w-16 h-16 rounded-2xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="award" class="w-8 h-8 text-dark"></i>
                </div>
                <h3 class="text-lg font-bold text-white mb-2">Kalite Garantisi</h3>
                <p class="text-gray-400 text-sm">Tüm ürünlerimizde 5 yıl garanti sunuyoruz.</p>
            </div>
            <div class="text-center p-6">
                <div class="w-16 h-16 rounded-2xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="users" class="w-8 h-8 text-dark"></i>
                </div>
                <h3 class="text-lg font-bold text-white mb-2">Uzman Kadro</h3>
                <p class="text-gray-400 text-sm">Deneyimli montaj ekibimizle profesyonel hizmet.</p>
            </div>
            <div class="text-center p-6">
                <div class="w-16 h-16 rounded-2xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="clock" class="w-8 h-8 text-dark"></i>
                </div>
                <h3 class="text-lg font-bold text-white mb-2">Zamanında Teslimat</h3>
                <p class="text-gray-400 text-sm">Söz verdiğimiz tarihlerde projenizi teslim ediyoruz.</p>
            </div>
            <div class="text-center p-6">
                <div class="w-16 h-16 rounded-2xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="headphones" class="w-8 h-8 text-dark"></i>
                </div>
                <h3 class="text-lg font-bold text-white mb-2">7/24 Destek</h3>
                <p class="text-gray-400 text-sm">Satış sonrası destek ekibimiz her zaman yanınızda.</p>
            </div>
        </div>
    </div>
</section>

<!-- Tente.net Ağı -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4 text-center">
        <span class="text-gold text-sm font-semibold uppercase mb-4 block">TENTE.NET AĞI</span>
        <h2 class="text-3xl font-heading font-bold text-white mb-8">Ege Bölgesi Kapsamında Hizmet</h2>
        
        <div class="flex flex-wrap justify-center gap-4">
            <?php foreach (DOMAIN_NETWORK as $domain => $name): ?>
            <a href="https://<?= $domain ?>" 
               target="_blank"
               class="px-6 py-3 rounded-lg border border-gold/30 text-gold hover:bg-gold/10 transition-all">
                <?= htmlspecialchars($name) ?>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
