<?php
/**
 * Blog Detay Sayfası - Yapı Dekorasyon
 */

// URL'den slug'ı al
$slug = $router->getParam('slug');

if (!$slug) {
    header('Location: ' . Router::url('/blog'));
    exit;
}

// Veritabanından yazıyı çek
try {
    $post = db()->fetchOne("SELECT * FROM blog_posts WHERE slug = ? AND status = 'published'", [$slug]);
    
    if (!$post) {
        $router->render404();
        exit;
    }
    
    // Görüntülenme sayısını artır
    db()->execute("UPDATE blog_posts SET views = views + 1 WHERE id = ?", [$post['id']]);
    
} catch (Exception $e) {
    $router->render404();
    exit;
}

// SEO bilgileri
seo()->setPage('blog-detail', $post);

// Önceki ve sonraki yazılar
$prevPost = db()->fetchOne("SELECT title, slug FROM blog_posts WHERE id < ? AND status = 'published' ORDER BY id DESC LIMIT 1", [$post['id']]);
$nextPost = db()->fetchOne("SELECT title, slug FROM blog_posts WHERE id > ? AND status = 'published' ORDER BY id ASC LIMIT 1", [$post['id']]);

ob_start();
?>

<!-- Hero / Breadcrumb -->
<section class="pt-32 pb-16 relative bg-dark overflow-hidden">
    <div class="absolute inset-0 opacity-20">
        <img src="<?= htmlspecialchars($post['image'] ?? 'assets/images/hero-bg.jpg') ?>" alt="" class="w-full h-full object-cover blur-sm">
        <div class="absolute inset-0 bg-dark/80"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="max-w-4xl mx-auto text-center">
            <!-- Breadcrumb -->
            <nav class="flex items-center justify-center gap-2 text-sm text-gray-400 mb-6">
                <a href="<?= Router::url('/') ?>" class="hover:text-gold transition-colors">Ana Sayfa</a>
                <span>/</span>
                <a href="<?= Router::url('/blog') ?>" class="hover:text-gold transition-colors">Blog</a>
                <span>/</span>
                <span class="text-gold"><?= htmlspecialchars($post['category'] ?? 'Genel') ?></span>
            </nav>
            
            <h1 class="text-3xl md:text-5xl font-heading font-bold text-white mb-6 leading-tight">
                <?= htmlspecialchars($post['title']) ?>
            </h1>
            
            <div class="flex items-center justify-center gap-6 text-sm text-gray-400">
                <span class="flex items-center gap-2">
                    <i data-lucide="calendar" class="w-4 h-4 text-gold"></i>
                    <?= date('d.m.Y', strtotime($post['created_at'])) ?>
                </span>
                <span class="flex items-center gap-2">
                    <i data-lucide="eye" class="w-4 h-4 text-gold"></i>
                    <?= $post['views'] ?> Okunma
                </span>
                <span class="flex items-center gap-2">
                    <i data-lucide="clock" class="w-4 h-4 text-gold"></i>
                    5 dk okuma
                </span>
            </div>
        </div>
    </div>
</section>

<!-- Content -->
<section class="py-16 bg-dark">
    <div class="container mx-auto px-4">
        <div class="flex flex-col lg:flex-row gap-12">
            
            <!-- Main Content -->
            <main class="w-full lg:w-2/3">
                <!-- Featured Image -->
                <div class="rounded-2xl overflow-hidden mb-10 shadow-2xl border border-dark-border">
                    <img src="<?= htmlspecialchars($post['image'] ?? 'assets/images/default-blog.jpg') ?>" 
                         alt="<?= htmlspecialchars($post['title']) ?>"
                         class="w-full h-auto">
                </div>
                
                <!-- Article Body -->
                <div class="prose prose-lg prose-invert max-w-none mb-12">
                    <?= $post['content'] // HTML içerik olduğu için htmlspecialchars kullanmıyoruz ?>
                </div>
                
                <!-- Tags -->
                <?php if (!empty($post['tags'])): ?>
                <div class="flex flex-wrap gap-2 mb-12 border-t border-dark-border pt-6">
                    <?php foreach (explode(',', $post['tags']) as $tag): ?>
                        <span class="bg-dark-card text-gray-300 px-3 py-1 rounded-full text-sm hover:text-gold hover:bg-dark-border transition-colors cursor-pointer">
                            #<?= trim($tag) ?>
                        </span>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                
                <!-- Share -->
                <div class="flex items-center justify-between p-6 bg-dark-card rounded-xl border border-dark-border mb-12">
                    <span class="font-bold text-white">Bu yazıyı paylaş:</span>
                    <div class="flex gap-4">
                        <a href="#" class="w-10 h-10 rounded-full bg-dark flex items-center justify-center text-gray-400 hover:text-blue-500 hover:bg-white transition-colors">
                            <i data-lucide="facebook" class="w-5 h-5"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full bg-dark flex items-center justify-center text-gray-400 hover:text-sky-500 hover:bg-white transition-colors">
                            <i data-lucide="twitter" class="w-5 h-5"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full bg-dark flex items-center justify-center text-gray-400 hover:text-green-500 hover:bg-white transition-colors">
                            <i data-lucide="message-circle" class="w-5 h-5"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Prev/Next Navigation -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <?php if ($prevPost): ?>
                    <a href="<?= Router::url('/blog/' . $prevPost['slug']) ?>" class="block p-6 bg-dark-card rounded-xl border border-dark-border hover:border-gold/30 transition-all group">
                        <span class="text-xs text-gray-500 mb-2 block group-hover:text-gold">ÖNCEKİ YAZI</span>
                        <h4 class="font-bold text-white line-clamp-2"><?= htmlspecialchars($prevPost['title']) ?></h4>
                    </a>
                    <?php else: ?>
                    <div class="hidden md:block"></div>
                    <?php endif; ?>
                    
                    <?php if ($nextPost): ?>
                    <a href="<?= Router::url('/blog/' . $nextPost['slug']) ?>" class="block p-6 bg-dark-card rounded-xl border border-dark-border hover:border-gold/30 transition-all text-right group">
                        <span class="text-xs text-gray-500 mb-2 block group-hover:text-gold">SONRAKİ YAZI</span>
                        <h4 class="font-bold text-white line-clamp-2"><?= htmlspecialchars($nextPost['title']) ?></h4>
                    </a>
                    <?php endif; ?>
                </div>
            </main>
            
            <!-- Sidebar -->
            <aside class="w-full lg:w-1/3 space-y-8">
                <!-- Search -->
                <div class="bg-dark-card p-6 rounded-xl border border-dark-border">
                    <h3 class="font-heading font-bold text-xl text-white mb-4">Arama</h3>
                    <form action="<?= Router::url('/blog') ?>" class="relative">
                        <input type="text" placeholder="Blogda ara..." class="w-full bg-dark border border-dark-border rounded-lg pl-4 pr-10 py-3 text-white focus:outline-none focus:border-gold">
                        <button type="submit" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gold">
                            <i data-lucide="search" class="w-5 h-5"></i>
                        </button>
                    </form>
                </div>
                
                <!-- Categories -->
                <div class="bg-dark-card p-6 rounded-xl border border-dark-border">
                    <h3 class="font-heading font-bold text-xl text-white mb-4">Kategoriler</h3>
                    <ul class="space-y-3">
                        <li>
                            <a href="#" class="flex justify-between items-center text-gray-400 hover:text-gold transition-colors group">
                                <span>Tadilat Rehberi</span>
                                <span class="bg-dark px-2 py-0.5 rounded text-xs text-gray-600 group-hover:text-gold transition-colors">12</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex justify-between items-center text-gray-400 hover:text-gold transition-colors group">
                                <span>İç Mimarlık</span>
                                <span class="bg-dark px-2 py-0.5 rounded text-xs text-gray-600 group-hover:text-gold transition-colors">8</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex justify-between items-center text-gray-400 hover:text-gold transition-colors group">
                                <span>Dekorasyon Fikirleri</span>
                                <span class="bg-dark px-2 py-0.5 rounded text-xs text-gray-600 group-hover:text-gold transition-colors">15</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex justify-between items-center text-gray-400 hover:text-gold transition-colors group">
                                <span>Maliyet Hesaplama</span>
                                <span class="bg-dark px-2 py-0.5 rounded text-xs text-gray-600 group-hover:text-gold transition-colors">5</span>
                            </a>
                        </li>
                    </ul>
                </div>
                
                <!-- CTA Banner -->
                <div class="bg-gradient-to-br from-gold to-yellow-600 rounded-xl p-8 text-center text-dark relative overflow-hidden">
                    <div class="relative z-10">
                        <h3 class="font-heading font-bold text-2xl mb-3">Tadilat Fiyatı Alın</h3>
                        <p class="mb-6 font-medium opacity-90">Hayalinizdeki proje için ücretsiz keşif ve fiyat teklifi isteyin.</p>
                        <a href="<?= Router::url('/teklif-al') ?>" class="bg-dark text-white px-6 py-3 rounded-lg font-bold hover:bg-white hover:text-dark transition-colors inline-block w-full">
                            Teklif İste
                        </a>
                    </div>
                </div>
            </aside>
            
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
