<?php
/**
 * Blog Liste Sayfası - Yapı Dekorasyon
 */

$pageTitle = 'Blog | Tadilat, Dekorasyon ve İç Mimar Rehberi';
$pageDescription = 'Ev yenileme, dekorasyon trendleri, banyo ve mutfak tadilatı hakkında ipuçları, maliyet rehberleri ve ilham veren fikirler.';

seo()->setPage('blog');

// Veritabanından blog yazılarını çek
try {
    $posts = db()->fetchAll("SELECT * FROM blog_posts WHERE status = 'published' ORDER BY created_at DESC");
} catch (Exception $e) {
    $posts = [];
}

ob_start();
?>

<!-- Hero -->
<section class="py-20 bg-gradient-to-b from-dark-card to-dark relative overflow-hidden">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-10 pointer-events-none">
        <div class="absolute top-0 right-0 w-96 h-96 bg-gold/20 rounded-full blur-3xl transform translate-x-1/2 -translate-y-1/2"></div>
        <div class="absolute bottom-0 left-0 w-96 h-96 bg-blue-500/10 rounded-full blur-3xl transform -translate-x-1/2 translate-y-1/2"></div>
    </div>

    <div class="container mx-auto px-4 text-center relative z-10">
        <span class="inline-block text-gold text-sm font-semibold tracking-wider uppercase mb-4" data-aos="fade-down">BLOG & REHBER</span>
        <h1 class="text-4xl md:text-5xl font-heading font-bold text-white mb-6" data-aos="fade-up">
            Tadilat ve Dekorasyon Dünyası
        </h1>
        <p class="text-xl text-gray-400 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
            Evinizi yenilerken ihtiyacınız olan ilham verici fikirler, teknik bilgiler ve trendler.
        </p>
    </div>
</section>

<!-- Blog Grid -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        
        <?php if (empty($posts)): ?>
            <!-- Boş Durum -->
            <div class="text-center py-20">
                <div class="w-20 h-20 bg-dark-card rounded-full flex items-center justify-center mx-auto mb-6">
                    <i data-lucide="book-open" class="w-10 h-10 text-gray-600"></i>
                </div>
                <h3 class="text-2xl font-bold text-white mb-4">Henüz İçerik Eklenmedi</h3>
                <p class="text-gray-400 max-w-lg mx-auto mb-8">
                    Editörlerimiz şu anda harika içerikler hazırlıyor. Çok yakında burada dekorasyon rehberleri bulabileceksiniz.
                </p>
                <a href="<?= Router::url('/') ?>" class="btn-gold px-8 py-3 rounded-lg font-bold inline-flex items-center gap-2">
                    <i data-lucide="home" class="w-4 h-4"></i>
                    Ana Sayfaya Dön
                </a>
            </div>
        <?php else: ?>
            <!-- Yazı Listesi -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($posts as $post): ?>
                    <article class="card-dark rounded-xl overflow-hidden group hover:shadow-2xl hover:shadow-gold/10 transition-all duration-300 transform hover:-translate-y-2">
                        <!-- Image -->
                        <a href="<?= Router::url('/blog/' . $post['slug']) ?>" class="block relative h-64 overflow-hidden">
                            <img src="<?= htmlspecialchars($post['image'] ?? 'assets/images/default-blog.jpg') ?>" 
                                 alt="<?= htmlspecialchars($post['title']) ?>"
                                 class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>
                            
                            <!-- Category Badge -->
                            <span class="absolute top-4 left-4 bg-gold text-dark text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wider">
                                <?= htmlspecialchars($post['category'] ?? 'Genel') ?>
                            </span>
                        </a>
                        
                        <!-- Content -->
                        <div class="p-6">
                            <div class="flex items-center gap-4 text-sm text-gray-500 mb-4">
                                <span class="flex items-center gap-1">
                                    <i data-lucide="calendar" class="w-4 h-4 text-gold"></i>
                                    <?= date('d.m.Y', strtotime($post['created_at'])) ?>
                                </span>
                                <span class="flex items-center gap-1">
                                    <i data-lucide="user" class="w-4 h-4 text-gold"></i>
                                    Admin
                                </span>
                            </div>
                            
                            <h2 class="text-xl font-bold text-white mb-3 group-hover:text-gold transition-colors line-clamp-2">
                                <a href="<?= Router::url('/blog/' . $post['slug']) ?>">
                                    <?= htmlspecialchars($post['title']) ?>
                                </a>
                            </h2>
                            
                            <p class="text-gray-400 mb-6 line-clamp-3 text-sm">
                                <?= htmlspecialchars($post['short_description'] ?? substr(strip_tags($post['content']), 0, 150) . '...') ?>
                            </p>
                            
                            <a href="<?= Router::url('/blog/' . $post['slug']) ?>" class="inline-flex items-center gap-2 text-gold font-semibold hover:text-white transition-colors">
                                Devamını Oku
                                <i data-lucide="arrow-right" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Newsletter / CTA -->
<section class="py-16 bg-dark-card border-t border-dark-border">
    <div class="container mx-auto px-4">
        <div class="bg-gradient-to-r from-gold/10 to-transparent p-8 md:p-12 rounded-2xl border border-gold/10 flex flex-col md:flex-row items-center justify-between gap-8">
            <div class="text-center md:text-left">
                <h2 class="text-2xl md:text-3xl font-heading font-bold text-white mb-2">Tadilat Fikirleri İster misiniz?</h2>
                <p class="text-gray-400">En yeni trendler ve kampanya haberleri için bültenimize abone olun.</p>
            </div>
            <div class="w-full md:w-auto">
                <form class="flex flex-col sm:flex-row gap-4">
                    <input type="email" placeholder="E-posta adresiniz" class="bg-dark border border-dark-border rounded-lg px-6 py-3 text-white focus:outline-none focus:border-gold w-full sm:w-80">
                    <button type="submit" class="btn-gold px-8 py-3 rounded-lg font-bold whitespace-nowrap">Abone Ol</button>
                </form>
            </div>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
