<?php
/**
 * Şehir Landing Sayfası
 * İzmir Tenteci V2
 */

$citySlug = $router->getParam('city');

// Şehri bul
$city = db()->fetchOne(
    "SELECT * FROM cities WHERE slug = ? AND is_active = 1",
    [$citySlug]
);

if (!$city) {
    $router->render404();
    return;
}

$cityName = $city['name'];
$pageTitle = "{$cityName} Tente ve Pergola | İzmir Tenteci";
$pageDescription = "{$cityName} ve çevresinde profesyonel tente, pergola ve cam balkon sistemleri. Ücretsiz keşif ve kurulum.";

// Hizmetleri çek
$services = db()->fetchAll(
    "SELECT * FROM services WHERE is_featured = 1 AND is_active = 1 ORDER BY display_order LIMIT 6"
);

ob_start();
?>

<!-- Hero -->
<section class="py-20 bg-gradient-to-b from-dark-card to-dark relative overflow-hidden">
    <div class="absolute inset-0 opacity-5" style="background-image: url('data:image/svg+xml,%3Csvg width=\"60\" height=\"60\" viewBox=\"0 0 60 60\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"none\" fill-rule=\"evenodd\"%3E%3Cg fill=\"%23D4AF37\" fill-opacity=\"0.4\"%3E%3Cpath d=\"M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    
    <div class="container mx-auto px-4 text-center relative z-10">
        <div class="inline-flex items-center gap-2 bg-gold/10 border border-gold/30 rounded-full px-4 py-2 mb-6">
            <i data-lucide="map-pin" class="w-4 h-4 text-gold"></i>
            <span class="text-gold text-sm font-medium"><?= htmlspecialchars($cityName) ?> Bölgesi</span>
        </div>
        
        <h1 class="text-4xl md:text-6xl font-heading font-bold text-white mb-6">
            <?= htmlspecialchars($cityName) ?> <span class="text-gradient-gold">Tente ve Pergola</span>
        </h1>
        
        <p class="text-xl text-gray-400 max-w-3xl mx-auto mb-10">
            <?= htmlspecialchars($cityName) ?> ve çevresinde 35 yıllık tecrübemizle profesyonel tente, pergola ve cam balkon hizmetleri sunuyoruz. 
            TENTE.NET ağının kalite güvencesiyle hizmetinizdeyiz.
        </p>
        
        <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
            <a href="tel:<?= setting('contact_phone', SITE_PHONE) ?>" class="btn-gold px-8 py-4 rounded-lg text-dark font-bold text-lg flex items-center gap-2">
                <i data-lucide="phone" class="w-5 h-5"></i>
                Hemen Ara
            </a>
            <a href="<?= Router::url('/teklif-al') ?>" class="px-8 py-4 rounded-lg border border-gold/50 text-gold font-bold text-lg hover:bg-gold/10 transition-all flex items-center gap-2">
                <i data-lucide="calculator" class="w-5 h-5"></i>
                Ücretsiz Teklif
            </a>
        </div>
    </div>
</section>

<!-- Neden Biz -->
<section class="py-16 bg-dark">
    <div class="container mx-auto px-4">
        <h2 class="text-2xl font-heading font-bold text-white mb-8 text-center">
            <?= htmlspecialchars($cityName) ?>'da Neden Bizi Tercih Etmelisiniz?
        </h2>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="card-dark rounded-xl p-6 text-center">
                <div class="w-14 h-14 rounded-xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="truck" class="w-7 h-7 text-dark"></i>
                </div>
                <h3 class="font-bold text-white mb-2">Ücretsiz Keşif</h3>
                <p class="text-gray-400 text-sm"><?= htmlspecialchars($cityName) ?> genelinde ücretsiz yerinde ölçüm</p>
            </div>
            <div class="card-dark rounded-xl p-6 text-center">
                <div class="w-14 h-14 rounded-xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="shield-check" class="w-7 h-7 text-dark"></i>
                </div>
                <h3 class="font-bold text-white mb-2">5 Yıl Garanti</h3>
                <p class="text-gray-400 text-sm">Tüm ürünlerde yazılı garanti</p>
            </div>
            <div class="card-dark rounded-xl p-6 text-center">
                <div class="w-14 h-14 rounded-xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="clock" class="w-7 h-7 text-dark"></i>
                </div>
                <h3 class="font-bold text-white mb-2">Hızlı Kurulum</h3>
                <p class="text-gray-400 text-sm">Profesyonel ekip ile zamanında teslimat</p>
            </div>
            <div class="card-dark rounded-xl p-6 text-center">
                <div class="w-14 h-14 rounded-xl gradient-gold flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="headphones" class="w-7 h-7 text-dark"></i>
                </div>
                <h3 class="font-bold text-white mb-2">7/24 Destek</h3>
                <p class="text-gray-400 text-sm">Satış sonrası teknik destek</p>
            </div>
        </div>
    </div>
</section>

<!-- Hizmetler -->
<section class="py-16 bg-dark-card">
    <div class="container mx-auto px-4">
        <h2 class="text-2xl font-heading font-bold text-white mb-8 text-center">
            <?= htmlspecialchars($cityName) ?>'da Sunduğumuz Hizmetler
        </h2>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($services as $service): ?>
            <a href="<?= Router::serviceUrl($service['slug']) ?>" class="group card-dark rounded-2xl p-6 transition-all hover:border-gold/30">
                <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center mb-4">
                    <i data-lucide="<?= $service['icon'] ?? 'umbrella' ?>" class="w-6 h-6 text-dark"></i>
                </div>
                <h3 class="text-lg font-bold text-white group-hover:text-gold transition-colors mb-2">
                    <?= htmlspecialchars($cityName) ?> <?= htmlspecialchars($service['name']) ?>
                </h3>
                <p class="text-gray-400 text-sm"><?= htmlspecialchars($service['short_description'] ?? '') ?></p>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="py-16 bg-gradient-to-r from-gold-dark via-gold to-gold-light">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl font-heading font-bold text-dark mb-4">
            <?= htmlspecialchars($cityName) ?>'da Ücretsiz Keşif
        </h2>
        <p class="text-dark/80 mb-8">
            Hemen arayın, aynı gün keşif randevusu alın.
        </p>
        <a href="tel:<?= setting('contact_phone', SITE_PHONE) ?>" 
           class="inline-flex items-center gap-2 bg-dark text-white px-8 py-4 rounded-lg font-bold hover:bg-dark-card transition-all">
            <i data-lucide="phone" class="w-5 h-5"></i>
            <?= setting('contact_phone', SITE_PHONE) ?>
        </a>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
