<?php
/**
 * İletişim Sayfası
 * İzmir Tenteci V2
 */

$pageTitle = 'İletişim | İzmir Tenteci';
$pageDescription = 'İzmir Tenteci ile iletişime geçin. Ücretsiz keşif ve fiyat teklifi için hemen arayın.';

$phone = site('contact_phone', SITE_PHONE);
$email = site('contact_email', SITE_EMAIL);
$address = site('contact_address', SITE_ADDRESS);
$whatsapp = site('contact_whatsapp', SITE_WHATSAPP);

// Form gönderimi (fallback for non-JS)
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_SERVER['HTTP_X_REQUESTED_WITH'])) {
    $name = trim($_POST['name'] ?? '');
    $phoneInput = trim($_POST['phone'] ?? '');
    $emailInput = trim($_POST['email'] ?? '');
    $message = trim($_POST['message'] ?? '');
    
    if (empty($name) || empty($phoneInput)) {
        $error = 'Lütfen adınızı ve telefon numaranızı girin.';
    } else {
        try {
            db()->execute(
                "INSERT INTO contact_forms (name, phone, email, message, ip_address, status) VALUES (?, ?, ?, ?, ?, 'new')",
                [$name, $phoneInput, $emailInput, $message, $_SERVER['REMOTE_ADDR'] ?? '']
            );
            $success = true;
        } catch (Exception $e) {
            $error = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        }
    }
}

ob_start();
?>

<!-- Hero -->
<section class="py-20 bg-gradient-to-b from-dark-card to-dark">
    <div class="container mx-auto px-4 text-center">
        <span class="inline-block text-gold text-sm font-semibold tracking-wider uppercase mb-4">İLETİŞİM</span>
        <h1 class="text-4xl md:text-5xl font-heading font-bold text-white mb-6">
            Bizimle İletişime Geçin
        </h1>
        <p class="text-xl text-gray-400 max-w-3xl mx-auto">
            Ücretsiz keşif ve fiyat teklifi için hemen arayın veya form doldurun.
        </p>
    </div>
</section>

<!-- İletişim Bilgileri + Form -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            
            <!-- Sol - Bilgiler -->
            <div>
                <h2 class="text-2xl font-heading font-bold text-white mb-8">İletişim Bilgilerimiz</h2>
                
                <div class="space-y-6">
                    <a href="tel:<?= $phone ?>" class="flex items-start gap-4 p-4 card-dark rounded-xl hover:border-gold/30 transition-all">
                        <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center flex-shrink-0">
                            <i data-lucide="phone" class="w-6 h-6 text-dark"></i>
                        </div>
                        <div>
                            <div class="font-semibold text-white mb-1">Telefon</div>
                            <div class="text-gold text-lg"><?= $phone ?></div>
                        </div>
                    </a>
                    
                    <a href="https://wa.me/<?= $whatsapp ?>" target="_blank" class="flex items-start gap-4 p-4 card-dark rounded-xl hover:border-green-500/30 transition-all">
                        <div class="w-12 h-12 rounded-lg bg-green-500 flex items-center justify-center flex-shrink-0">
                            <i data-lucide="message-circle" class="w-6 h-6 text-white"></i>
                        </div>
                        <div>
                            <div class="font-semibold text-white mb-1">WhatsApp</div>
                            <div class="text-green-400 text-lg">Hızlı Mesaj Gönder</div>
                        </div>
                    </a>
                    
                    <a href="mailto:<?= $email ?>" class="flex items-start gap-4 p-4 card-dark rounded-xl hover:border-gold/30 transition-all">
                        <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center flex-shrink-0">
                            <i data-lucide="mail" class="w-6 h-6 text-dark"></i>
                        </div>
                        <div>
                            <div class="font-semibold text-white mb-1">E-posta</div>
                            <div class="text-gold"><?= $email ?></div>
                        </div>
                    </a>
                    
                    <div class="flex items-start gap-4 p-4 card-dark rounded-xl">
                        <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center flex-shrink-0">
                            <i data-lucide="map-pin" class="w-6 h-6 text-dark"></i>
                        </div>
                        <div>
                            <div class="font-semibold text-white mb-1">Adres</div>
                            <div class="text-gray-400"><?= $address ?></div>
                        </div>
                    </div>
                    
                    <div class="flex items-start gap-4 p-4 card-dark rounded-xl">
                        <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center flex-shrink-0">
                            <i data-lucide="clock" class="w-6 h-6 text-dark"></i>
                        </div>
                        <div>
                            <div class="font-semibold text-white mb-1">Çalışma Saatleri</div>
                            <div class="text-gray-400">Pazartesi - Cumartesi: 09:00 - 18:00</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sağ - Form -->
            <div class="card-dark rounded-2xl p-8">
                <h2 class="text-2xl font-heading font-bold text-white mb-6">Mesaj Gönderin</h2>
                
                <?php if ($success): ?>
                <div class="bg-green-500/10 border border-green-500/30 text-green-400 rounded-lg p-4 mb-6">
                    <i data-lucide="check-circle" class="w-5 h-5 inline mr-2"></i>
                    Mesajınız başarıyla gönderildi. En kısa sürede size dönüş yapacağız.
                </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                <div class="bg-red-500/10 border border-red-500/30 text-red-400 rounded-lg p-4 mb-6">
                    <i data-lucide="alert-circle" class="w-5 h-5 inline mr-2"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
                <?php endif; ?>
                
                <form method="POST" class="space-y-6">
                    <div>
                        <label class="block text-gray-400 mb-2">Adınız Soyadınız *</label>
                        <input type="text" name="name" required
                               class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                               placeholder="Adınız Soyadınız">
                    </div>
                    
                    <div>
                        <label class="block text-gray-400 mb-2">Telefon *</label>
                        <input type="tel" name="phone" required
                               class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                               placeholder="05XX XXX XX XX">
                    </div>
                    
                    <div>
                        <label class="block text-gray-400 mb-2">E-posta</label>
                        <input type="email" name="email"
                               class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                               placeholder="ornek@email.com">
                    </div>
                    
                    <div>
                        <label class="block text-gray-400 mb-2">Mesajınız</label>
                        <textarea name="message" rows="4"
                                  class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors resize-none"
                                  placeholder="Mesajınızı yazın..."></textarea>
                    </div>
                    
                    <button type="submit" class="w-full btn-gold py-4 rounded-lg text-dark font-bold flex items-center justify-center gap-2">
                        <i data-lucide="send" class="w-5 h-5"></i>
                        Gönder
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Harita -->
<section class="h-96 bg-dark-card">
    <iframe 
        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3127.1!2d27.055!3d38.392!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzjCsDIzJzMxLjIiTiAyN8KwMDMnMTguMCJF!5e0!3m2!1str!2str!4v1"
        width="100%" 
        height="100%" 
        style="border:0;" 
        allowfullscreen="" 
        loading="lazy"
        referrerpolicy="no-referrer-when-downgrade">
    </iframe>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
