<?php
/**
 * Sıkça Sorulan Sorular (SSS) - Yapı Dekorasyon
 */

$pageTitle = 'Sıkça Sorulan Sorular | Tadilat Hakkında Merak Edilenler';
$pageDescription = 'Tadilat süreçleri, fiyatlandırma, süreler ve garanti koşulları hakkında en çok sorulan soruların cevapları.';

seo()->setPage('faq');

$faqs = [
    [
        'q' => 'Anahtar teslim tadilat neleri kapsar?',
        'a' => 'Anahtar teslim tadilat hizmetimiz; keşif, projelendirme, kırım-döküm, elektrik ve su tesisatı yenileme, zemin döşeme, boya-badana, mutfak ve banyo dolapları montajı ve temizlik dahil tüm süreçleri kapsar. Size sadece eşyalarınızı yerleştirip keyfini çıkarmak kalır.'
    ],
    [
        'q' => 'Tadilat ne kadar sürer?',
        'a' => 'Süre projenin kapsamına göre değişir. Ortalama olarak komple bir daire tadilatı 20-30 gün sürerken, sadece banyo veya mutfak yenileme işlemi 7-10 gün içerisinde tamamlanmaktadır. İş başlangıcında size net bir iş takvimi sunuyoruz.'
    ],
    [
        'q' => 'Ücretsiz keşif hizmetiniz var mı?',
        'a' => 'Evet, İzmir ve çevresinde tüm müşterilerimize ücretsiz keşif ve fiyat teklifi hizmeti sunuyoruz. Uzman ekibimiz yerinde inceleme yaparak ihtiyaçlarınızı belirler.'
    ],
    [
        'q' => 'Ödeme seçenekleri nelerdir?',
        'a' => 'Nakit, havale/EFT ve kredi kartına taksit seçeneklerimiz mevcuttur. Genellikle iş başlangıcında bir ön ödeme alıyor, kalan tutarı ise iş tesliminde tahsil ediyoruz.'
    ],
    [
        'q' => 'Yapılan işler için garanti veriyor musunuz?',
        'a' => 'Kesinlikle. Kullandığımız tüm malzemeler üretici garantisi altındadır. Ayrıca işçilik hatalarına karşı firmamız tarafından 2 yıl garanti verilmektedir.'
    ],
    [
        'q' => 'Kendi malzememi alabilir miyim?',
        'a' => 'Evet, dilerseniz seramik, parke, batarya gibi vitrifiye malzemelerini kendiniz temin edebilirsiniz. Bu durumda biz sadece işçilik ve sarf malzeme (yapıştırıcı, derz vb.) ücreti talep ederiz.'
    ],
    [
        'q' => 'Hangi bölgelere hizmet veriyorsunuz?',
        'a' => 'Başta İzmir merkez olmak üzere; Çeşme, Urla, Seferihisar, Foça, Menderes, Aliağa gibi tüm ilçelere ve Manisa, Aydın gibi çevre illere hizmet vermekteyiz.'
    ]
];

ob_start();
?>

<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <div class="hero-breadcrumb">
            <a href="<?= Router::url('/') ?>">Ana Sayfa</a>
            <i data-lucide="chevron-right"></i>
            <span class="text-white">S.S.S</span>
        </div>
        
        <div class="hero-badge">Merak Ettikleriniz</div>
        <h1>Sıkça Sorulan Sorular</h1>
        <p class="lead">Tadilat ve dekorasyon süreçleri hakkında aklınıza takılan tüm soruların cevapları burada.</p>
    </div>
</section>

<!-- FAQ Accordion -->
<section class="section-padding faq-section">
    <div class="container">
        <div class="faq-container">
            <?php foreach ($faqs as $index => $faq): ?>
            <div class="faq-item" id="faq-item-<?= $index ?>">
                <button class="faq-trigger" onclick="toggleFaq(<?= $index ?>)">
                    <?= htmlspecialchars($faq['q']) ?>
                    <i data-lucide="chevron-down" id="faq-icon-<?= $index ?>"></i>
                </button>
                <div class="faq-content">
                    <?= htmlspecialchars($faq['a']) ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Still Have Questions? -->
        <div class="cta-banner" style="margin-top: 60px; border-radius: 12px; padding: 40px; background: var(--dark); text-align: center;">
            <h3 style="color: #fff; margin-bottom: 15px; font-size: 1.8rem;">Başka Sorunuz mu Var?</h3>
            <p style="color: #999; margin-bottom: 30px; max-width: 600px; margin-left: auto; margin-right: auto;">
                Aradığınız cevabı bulamadınız mı? Bizimle iletişime geçin, uzman ekibimiz size yardımcı olmaktan mutluluk duyacaktır.
            </p>
            <div style="display: flex; gap: 15px; justify-content: center;">
                <a href="<?= Router::url('/iletisim') ?>" class="btn btn-gold">
                    <i data-lucide="mail"></i> Bize Yazın
                </a>
                <a href="tel:<?= str_replace(' ', '', setting('site_phone')) ?>" class="btn btn-outline-dark" style="color: #fff; border-color: rgba(255,255,255,0.2);">
                    <i data-lucide="phone"></i> Hemen Arayın
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Simple Accordion Script -->
<script>
function toggleFaq(index) {
    const item = document.getElementById('faq-item-' + index);
    const icon = document.getElementById('faq-icon-' + index);
    
    // Toggle active class
    if (item.classList.contains('active')) {
        item.classList.remove('active');
    } else {
        // Optional: Close others
        document.querySelectorAll('.faq-item').forEach(el => el.classList.remove('active'));
        item.classList.add('active');
    }
}
</script>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
