<?php
/**
 * Gallery & Inspiration Page
 * Aegean Dominance - İzmir Tenteci V2
 */

$pageTitle = 'İlham Galerisi | İzmir Tenteci';
$pageDescription = 'Dönüşüm hikayeleri, uygulama örnekleri ve tasarım fikirleri. Tente ve pergola sistemlerimizle mekanların nasıl değiştiğini keşfedin.';

// Fetch Categories for Filtering
$categories = db()->fetchAll("SELECT DISTINCT category FROM services WHERE is_active = 1 ORDER BY category");

// Fetch All Images
$images = db()->fetchAll(
    "SELECT si.*, s.name as service_name, s.slug as service_slug, s.category 
     FROM service_images si 
     JOIN services s ON si.service_id = s.id 
     WHERE s.is_active = 1 
     ORDER BY si.is_featured DESC, si.id DESC 
     LIMIT 60"
);

ob_start();
?>

<!-- ============================================
     HERO & BEFORE/AFTER SHOWCASE
     ============================================ -->
<div class="relative bg-zinc-900 pt-32 pb-20 overflow-hidden">
    <div class="container mx-auto px-6">
        <div class="text-center mb-16">
            <h1 class="text-5xl md:text-6xl font-extrabold text-white mb-6">Dönüşüm Hikayeleri</h1>
            <p class="text-xl text-white/50 max-w-2xl mx-auto">
                Sıradan balkon ve terasların nasıl premium yaşam alanlarına dönüştüğüne tanık olun.
            </p>
        </div>

        <!-- Before/After Slider Component -->
        <div class="max-w-5xl mx-auto relative rounded-2xl overflow-hidden shadow-2xl border border-white/10 group select-none">
            <div class="relative w-full aspect-video" id="ba-slider">
                <!-- After Image (Background) -->
                <img src="https://images.unsplash.com/photo-1600607687939-ce8a6c25118c?w=1600&q=80" 
                     class="absolute inset-0 w-full h-full object-cover" 
                     alt="After">
                
                <!-- Before Image (Clipped) -->
                <div class="absolute inset-0 w-1/2 overflow-hidden border-r-2 border-gold" id="ba-clipper">
                    <img src="https://images.unsplash.com/photo-1599809275671-b5942cabc7ad?w=1600&q=80" 
                         class="absolute inset-0 w-full h-full object-cover max-w-none" 
                         style="width: 100vw; max-width: 1024px;" 
                         alt="Before"> <!-- Width needs adjustment via JS for responsiveness -->
                    
                    <div class="absolute bottom-6 left-6 bg-black/60 backdrop-blur px-3 py-1 rounded text-white text-sm font-bold">ÖNCESİ</div>
                </div>

                <div class="absolute bottom-6 right-6 bg-gold text-black px-3 py-1 rounded text-sm font-bold">SONRASI</div>

                <!-- Handle -->
                <div class="absolute inset-y-0 left-1/2 w-10 -ml-5 flex items-center justify-center cursor-ew-resize z-20" id="ba-handle">
                    <div class="w-10 h-10 rounded-full bg-gold border-4 border-black flex items-center justify-center shadow-lg">
                        <i data-lucide="move-horizontal" class="w-5 h-5 text-black"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ============================================
     MASONRY GALLERY
     ============================================ -->
<section class="py-20 bg-[#0a0a0a] min-h-screen">
    <div class="container mx-auto px-6">
        
        <!-- Filter Buttons -->
        <div class="flex flex-wrap justify-center gap-4 mb-12">
            <button class="filter-btn active px-6 py-2 rounded-full border border-gold bg-gold text-black font-bold transition-all" data-filter="all">Tümü</button>
            <?php foreach ($categories as $cat): ?>
            <button class="filter-btn px-6 py-2 rounded-full border border-white/10 text-white/70 hover:border-gold hover:text-gold transition-all" 
                    data-filter="<?= htmlspecialchars($cat['category']) ?>">
                <?= htmlspecialchars($cat['category']) ?>
            </button>
            <?php endforeach; ?>
        </div>

        <!-- Masonry Grid -->
        <div class="columns-1 md:columns-2 lg:columns-3 gap-4 space-y-4" id="gallery-grid">
            <?php foreach ($images as $image): ?>
            <div class="gallery-item break-inside-avoid relative group cursor-pointer overflow-hidden rounded-xl border border-white/5 bg-zinc-900" 
                 data-category="<?= htmlspecialchars($image['category']) ?>"
                 onclick="openLightbox('<?= Router::url('/' . ($image['image_webp'] ?? $image['image_path'])) ?>', '<?= htmlspecialchars($image['category']) ?>')">
                
                <img src="<?= Router::url('/' . ($image['image_webp'] ?? $image['image_path'])) ?>" 
                     alt="<?= htmlspecialchars($image['alt_text'] ?? 'Proje') ?>" 
                     class="w-full h-auto object-cover group-hover:scale-105 transition-transform duration-700"
                     loading="lazy">
                
                <div class="absolute inset-0 bg-black/60 opacity-0 group-hover:opacity-100 transition-opacity flex flex-col justify-end p-6">
                    <span class="text-gold text-xs font-bold uppercase tracking-widest mb-1"><?= htmlspecialchars($image['category']) ?></span>
                    <h3 class="text-white font-bold text-lg"><?= htmlspecialchars($image['service_name']) ?></h3>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

    </div>
</section>

<!-- Lightbox -->
<div id="lightbox" class="fixed inset-0 z-[100] bg-black/95 hidden items-center justify-center opacity-0 transition-opacity duration-300">
    <button class="absolute top-6 right-6 text-white/50 hover:text-white transition-colors z-50" onclick="closeLightbox()">
        <i data-lucide="x" class="w-10 h-10"></i>
    </button>
    
    <div class="relative max-w-6xl w-full max-h-screen p-4 flex flex-col items-center">
        <img id="lightbox-img" src="" class="max-h-[85vh] max-w-full object-contain rounded-lg shadow-2xl" alt="">
        <div class="mt-4 text-center">
            <span id="lightbox-cat" class="block text-gold text-sm font-bold uppercase tracking-widest mb-1"></span>
        </div>
    </div>
</div>

<script>
// Filter Logic
document.querySelectorAll('.filter-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        // Remove active class
        document.querySelectorAll('.filter-btn').forEach(b => {
            b.classList.remove('bg-gold', 'text-black', 'border-gold');
            b.classList.add('border-white/10', 'text-white/70');
        });
        
        // Add active class
        btn.classList.remove('border-white/10', 'text-white/70');
        btn.classList.add('bg-gold', 'text-black', 'border-gold');

        const filter = btn.dataset.filter;
        const items = document.querySelectorAll('.gallery-item');

        items.forEach(item => {
            if (filter === 'all' || item.dataset.category === filter) {
                gsap.to(item, {autoAlpha: 1, display: 'block', duration: 0.4});
            } else {
                gsap.to(item, {autoAlpha: 0, display: 'none', duration: 0.4});
            }
        });
    });
});

// Lightbox Logic
function openLightbox(src, cat) {
    const lb = document.getElementById('lightbox');
    const img = document.getElementById('lightbox-img');
    const txt = document.getElementById('lightbox-cat');
    
    img.src = src;
    txt.innerText = cat;
    
    lb.classList.remove('hidden');
    requestAnimationFrame(() => {
        lb.classList.remove('opacity-0');
    });
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    const lb = document.getElementById('lightbox');
    lb.classList.add('opacity-0');
    setTimeout(() => {
        lb.classList.add('hidden');
        document.body.style.overflow = '';
    }, 300);
}

// Before/After Slider Logic
const slider = document.getElementById('ba-slider');
const clipper = document.getElementById('ba-clipper');
const handle = document.getElementById('ba-handle');
let isDragging = false;

if (slider) {
    slider.addEventListener('mousedown', () => isDragging = true);
    slider.addEventListener('mouseup', () => isDragging = false);
    slider.addEventListener('mouseleave', () => isDragging = false);
    
    slider.addEventListener('mousemove', (e) => {
        if (!isDragging) return;
        const rect = slider.getBoundingClientRect();
        const x = Math.max(0, Math.min(e.clientX - rect.left, rect.width));
        const percent = (x / rect.width) * 100;
        
        clipper.style.width = percent + '%';
        handle.style.left = percent + '%';
    });
    
    // Touch support
    slider.addEventListener('touchstart', () => isDragging = true);
    slider.addEventListener('touchend', () => isDragging = false);
    slider.addEventListener('touchmove', (e) => {
        if (!isDragging) return;
        const rect = slider.getBoundingClientRect();
        const touch = e.touches[0];
        const x = Math.max(0, Math.min(touch.clientX - rect.left, rect.width));
        const percent = (x / rect.width) * 100;
        
        clipper.style.width = percent + '%';
        handle.style.left = percent + '%';
    });
}
</script>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
