<?php
/**
 * Home Page View - V2 Redesign (Wow Effect)
 * İzmir De Tadilat - Luxury Renovation & Tiny House
 */

$pageTitle = SEO_TITLE;
$pageDescription = SEO_DESCRIPTION;

ob_start();
?>

<!-- Hero Slider Section -->
<section class="hero-slider swiper">
    <div class="swiper-wrapper">
        <!-- Slide 1: General Renovation -->
        <div class="swiper-slide">
            <div class="hero-bg" style="background-image: url('https://images.unsplash.com/photo-1600585154340-be6161a56a0c?q=80&w=2070&auto=format&fit=crop');">
                <div class="overlay"></div>
            </div>
            <div class="hero-content container" data-aos="fade-up">
                <div class="badge-glass">İZMİR'İN PRESTİJLİ PROJELERİ</div>
                <h1>Hayallerinizdeki Evi<br><span class="text-gold">Gerçeğe Dönüştürüyoruz</span></h1>
                <p>İzmir genelinde anahtar teslim tadilat ve lüks dekorasyon çözümleri.</p>
                <div class="btn-group">
                    <a href="<?= Router::url('/teklif-al') ?>" class="btn btn-gold">Ücretsiz Keşif <i data-lucide="arrow-right"></i></a>
                    <a href="<?= Router::url('/galeri') ?>" class="btn btn-glass">Projelerimizi İnceleyin</a>
                </div>
            </div>
        </div>
        <!-- Slide 2: Tiny House -->
        <div class="swiper-slide">
            <div class="hero-bg" style="background-image: url('https://images.unsplash.com/photo-1512917774080-9991f1c4c750?q=80&w=2070&auto=format&fit=crop');">
                <div class="overlay"></div>
            </div>
            <div class="hero-content container">
                <div class="badge-glass">DOĞA İLE İÇ İÇE</div>
                <h1>Modern & Konforlu<br><span class="text-gold">Tiny House & Prefabrik</span></h1>
                <p>Minimalist yaşamın kapılarını aralayın. Size özel Tiny House tasarımları.</p>
                <div class="btn-group">
                    <a href="<?= Router::url('/tiny-house') ?>" class="btn btn-gold">Modelleri Gör <i data-lucide="home"></i></a>
                </div>
            </div>
        </div>
    </div>
    <!-- Slider Controls -->
    <div class="swiper-pagination"></div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
</section>

<!-- About / Intro Section -->
<section class="section-padding about-intro">
    <div class="container">
        <div class="row align-items-center gap-4">
            <div class="col-text" data-aos="fade-right">
                <span class="sub-heading">İZMİR DE TADİLAT</span>
                <h2>Yaşam Alanlarınıza <span class="text-gradient">Değer Katıyoruz</span></h2>
                <p>20 yılı aşkın tecrübemizle İzmir ve çevresinde ev, ofis, villa yenileme projelerinde fark yaratıyoruz. Sadece tadilat yapmıyor, yaşam kalitenizi artıracak estetik ve fonksiyonel çözümler üretiyoruz.</p>
                
                <ul class="feature-list">
                    <li><i data-lucide="check-circle"></i> Profesyonel İç Mimar Desteği</li>
                    <li><i data-lucide="check-circle"></i> Zamanında Teslimat Garantisi</li>
                    <li><i data-lucide="check-circle"></i> 1. Sınıf Malzeme ve İşçilik</li>
                </ul>
                
                <div class="stats-row">
                    <div class="stat-item">
                        <span class="stat-number">500+</span>
                        <span class="stat-label">Tamamlanan Proje</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-number">%100</span>
                        <span class="stat-label">Müşteri Memnuniyeti</span>
                    </div>
                </div>
            </div>
            <div class="col-image" data-aos="fade-left">
                <div class="image-stack">
                    <img src="https://images.unsplash.com/photo-1600607687939-ce8a6c25118c?w=800&q=80" class="img-back" alt="Tadilat">
                    <img src="https://images.unsplash.com/photo-1616486338812-3dadae4b4f9d?w=800&q=80" class="img-front" alt="Dekorasyon">
                    <div class="experience-badge">
                        <span class="years">20+</span>
                        <span class="text">Yıllık<br>Tecrübe</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Tiny House & Prefab Focus Section -->
<section class="section-padding tiny-house-section">
    <div class="bg-pattern"></div>
    <div class="container">
        <div class="section-header text-center" data-aos="fade-up">
            <span class="sub-heading text-white">YENİ NESİL YAŞAM</span>
            <h2 class="text-white">Tiny House & Prefabrik Çözümleri</h2>
            <p class="text-white-muted">İster bahçenizde bir ofis, ister doğada bir kaçış noktası. Hayalinizdeki yapıyı tasarlayıp, anahtar teslim kuruyoruz.</p>
        </div>

        <div class="tiny-grid">
            <!-- Card 1 -->
            <div class="tiny-card" data-aos="fade-up" data-aos-delay="100">
                <div class="tiny-img">
                    <img src="https://images.unsplash.com/photo-1525113990976-399835c4385d?w=800&q=80" alt="Tiny House Model 1">
                    <div class="tiny-overlay">
                        <a href="#" class="btn-icon glightbox"><i data-lucide="zoom-in"></i></a>
                    </div>
                </div>
                <div class="tiny-content">
                    <h3>Loft Model Tiny House</h3>
                    <p>Yüksek tavanlı, ferah ve modern tasarım. 4 mevsim yaşama uygun yalıtım.</p>
                    <a href="<?= Router::url('/iletisim') ?>" class="link-arrow">Fiyat Alın <i data-lucide="arrow-right"></i></a>
                </div>
            </div>
            
            <!-- Card 2 -->
            <div class="tiny-card" data-aos="fade-up" data-aos-delay="200">
                <div class="tiny-img">
                    <img src="https://images.unsplash.com/photo-1449844908441-8829872d2607?w=800&q=80" alt="Prefabrik Ofis">
                    <div class="tiny-overlay">
                        <a href="#" class="btn-icon glightbox"><i data-lucide="zoom-in"></i></a>
                    </div>
                </div>
                <div class="tiny-content">
                    <h3>Modern Prefabrik Villa</h3>
                    <p>Betonarme konforunda, hızlı kurulumlu ve depreme dayanıklı çelik konstrüksiyon yapılar.</p>
                    <a href="<?= Router::url('/iletisim') ?>" class="link-arrow">Fiyat Alın <i data-lucide="arrow-right"></i></a>
                </div>
            </div>
            
             <!-- Card 3 -->
             <div class="tiny-card" data-aos="fade-up" data-aos-delay="300">
                <div class="tiny-img">
                    <img src="https://images.unsplash.com/photo-1510798831971-661eb04b3739?w=800&q=80" alt="Bungalov">
                    <div class="tiny-overlay">
                        <a href="#" class="btn-icon glightbox"><i data-lucide="zoom-in"></i></a>
                    </div>
                </div>
                <div class="tiny-content">
                    <h3>Ahşap Bungalov</h3>
                    <p>Doğal ahşap dokusuyla sıcak ve huzurlu bir yaşam alanı.</p>
                    <a href="<?= Router::url('/iletisim') ?>" class="link-arrow">Fiyat Alın <i data-lucide="arrow-right"></i></a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Grid (Renovation) -->
<section class="section-padding services-section">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="sub-heading">HİZMETLERİMİZ</span>
            <h2>Komple Tadilat & Dekorasyon</h2>
        </div>
        
        <div class="services-wrapper">
            <!-- Service 1 -->
            <a href="<?= Router::serviceUrl('komple-tadilat') ?>" class="service-box" data-aos="fade-up">
                <div class="service-icon">
                    <i data-lucide="hammer"></i>
                </div>
                <h3>Anahtar Teslim Tadilat</h3>
                <p>Evinizin A'dan Z'ye tüm yenileme işlemlerini tek elden, profesyonelce yönetiyoruz.</p>
                <span class="service-link">İncele <i data-lucide="arrow-right"></i></span>
            </a>

            <!-- Service 2 -->
            <a href="<?= Router::serviceUrl('banyo-yenileme') ?>" class="service-box" data-aos="fade-up" data-aos-delay="100">
                <div class="service-icon">
                    <i data-lucide="droplets"></i>
                </div>
                <h3>Banyo Yenileme</h3>
                <p>Eskimiş banyolarınızı modern, ferah ve kullanışlı spa alanlarına dönüştürüyoruz.</p>
                <span class="service-link">İncele <i data-lucide="arrow-right"></i></span>
            </a>

            <!-- Service 3 -->
            <a href="<?= Router::serviceUrl('mutfak-yenileme') ?>" class="service-box" data-aos="fade-up" data-aos-delay="200">
                <div class="service-icon">
                    <i data-lucide="chef-hat"></i>
                </div>
                <h3>Mutfak Tasarımı</h3>
                <p>Fonksiyonel dolaplar, şık tezgahlar ve modern ankastre çözümler.</p>
                <span class="service-link">İncele <i data-lucide="arrow-right"></i></span>
            </a>

            <!-- Service 4 -->
            <a href="<?= Router::serviceUrl('ic-mekan-tasarimi') ?>" class="service-box" data-aos="fade-up" data-aos-delay="300">
                <div class="service-icon">
                    <i data-lucide="pen-tool"></i>
                </div>
                <h3>İç Mimarlık</h3>
                <p>3D görselleştirme ve profesyonel proje danışmanlığı.</p>
                <span class="service-link">İncele <i data-lucide="arrow-right"></i></span>
            </a>
        </div>
    </div>
</section>

<!-- Gallery Preview -->
<section class="section-padding gallery-preview">
    <div class="container">
        <div class="section-header text-center" data-aos="fade-up">
            <span class="sub-heading">GALERİ</span>
            <h2>Son Projelerimizden Kareler</h2>
        </div>
        
        <div class="gallery-grid">
            <a href="https://images.unsplash.com/photo-1600210492486-724fe5c67fb0?w=1200&q=80" class="gallery-item glightbox" data-aos="zoom-in">
                <img src="https://images.unsplash.com/photo-1600210492486-724fe5c67fb0?w=600&q=80" alt="Proje 1">
                <div class="gallery-overlay"><i data-lucide="maximize"></i></div>
            </a>
            <a href="https://images.unsplash.com/photo-1600607687644-aac4c3eac7f4?w=1200&q=80" class="gallery-item glightbox" data-aos="zoom-in" data-aos-delay="100">
                <img src="https://images.unsplash.com/photo-1600607687644-aac4c3eac7f4?w=600&q=80" alt="Proje 2">
                <div class="gallery-overlay"><i data-lucide="maximize"></i></div>
            </a>
            <a href="https://images.unsplash.com/photo-1600566753190-17f0baa2a6c3?w=1200&q=80" class="gallery-item glightbox" data-aos="zoom-in" data-aos-delay="200">
                <img src="https://images.unsplash.com/photo-1600566753190-17f0baa2a6c3?w=600&q=80" alt="Proje 3">
                <div class="gallery-overlay"><i data-lucide="maximize"></i></div>
            </a>
            <a href="https://images.unsplash.com/photo-1600585154340-be6161a56a0c?w=1200&q=80" class="gallery-item glightbox" data-aos="zoom-in" data-aos-delay="300">
                <img src="https://images.unsplash.com/photo-1600585154340-be6161a56a0c?w=600&q=80" alt="Proje 4">
                <div class="gallery-overlay"><i data-lucide="maximize"></i></div>
            </a>
        </div>
        <div class="text-center mt-5">
            <a href="<?= Router::url('/galeri') ?>" class="btn btn-outline-dark">Tüm Projeleri Gör</a>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="cta-banner" data-aos="fade-up">
    <div class="container">
        <div class="cta-content-box">
            <div class="cta-text">
                <h2>İzmir'de Tadilat Zamanı!</h2>
                <p>Ücretsiz keşif hizmetimizden yararlanın, projenizi yerinde inceleyip fiyatlandıralım.</p>
            </div>
            <div class="cta-actions">
                <a href="tel:<?= site('contact_phone', '02322771100') ?>" class="btn btn-white"><i data-lucide="phone-call"></i> Hemen Ara</a>
                <a href="https://wa.me/905362771709" class="btn btn-whatsapp"><i data-lucide="message-circle"></i> WhatsApp</a>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Init Hero Slider
        const swiper = new Swiper('.hero-slider', {
            loop: true,
            effect: 'fade',
            speed: 1000,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
        });

        // Init Lightbox
        const lightbox = GLightbox({
            selector: '.glightbox',
            touchNavigation: true,
            loop: true
        });
    });
</script>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>