<?php
/**
 * Layout Template - Original V1 Design Ported to V2
 * Aegean Dominance - Yapı Dekorasyon V2
 */

// Initialize SEO Manager
$seoManager = seo();
if (isset($seoPageType)) {
    $seoManager->setPage($seoPageType, $seoPageData ?? []);
}

$siteName = site('site_name', SITE_NAME);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php if (isset($seoPageType)): ?>
    <?= $seoManager->render() ?>
    <?php else: ?>
    <title><?= htmlspecialchars($pageTitle ?? SEO_TITLE) ?></title>
    <meta name="description" content="<?= htmlspecialchars($pageDescription ?? SEO_DESCRIPTION) ?>">
    <?php endif; ?>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?= Router::url('/assets/images/favicon.png') ?>">
    
    <!-- Google Fonts (from V1) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Outfit:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>

    <!-- AOS Animation Library -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <!-- GLightbox -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" />
    
    <!-- Main CSS (Ported from V1) -->
    <link rel="stylesheet" href="<?= Router::url('/assets/css/style.css') ?>">
</head>
<body>
    
    <!-- Header (Ported from V1 includes/header.php) -->
    <header class="site-header" id="siteHeader">
        <div class="header-container">
            <!-- Logo -->
            <a href="<?= Router::url('/') ?>" class="logo">
                <div class="logo-icon">
                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="20" cy="20" r="18" stroke="#c9a74e" stroke-width="2" fill="none"/>
                        <path d="M12 20 L20 12 L28 20 L20 28 Z" stroke="#c9a74e" stroke-width="2" fill="none"/>
                        <circle cx="20" cy="20" r="4" stroke="#c9a74e" stroke-width="2" fill="none"/>
                    </svg>
                </div>
                <div class="logo-text">
                    YAPI<br><span>DEKORASYON</span>
                </div>
            </a>
            
            <!-- Main Navigation -->
            <nav class="main-nav" id="mainNav">
                <ul class="nav-menu">
                    <li><a href="<?= Router::url('/') ?>" class="<?= $_SERVER['REQUEST_URI'] == Router::url('/') ? 'active' : '' ?>">Ana Sayfa</a></li>
                    <li><a href="<?= Router::url('/hizmetlerimiz') ?>" class="<?= strpos($_SERVER['REQUEST_URI'], 'hizmet') !== false ? 'active' : '' ?>">Hizmetlerimiz</a></li>
                    <li><a href="<?= Router::url('/hakkimizda') ?>" class="<?= strpos($_SERVER['REQUEST_URI'], 'hakkimizda') !== false ? 'active' : '' ?>">Hakkımızda</a></li>
                    <li><a href="<?= Router::url('/hizmet-bolgeleri') ?>" class="<?= strpos($_SERVER['REQUEST_URI'], 'bolge') !== false ? 'active' : '' ?>">Hizmet Bölgeleri</a></li>
                    <li><a href="<?= Router::url('/galeri') ?>" class="<?= strpos($_SERVER['REQUEST_URI'], 'galeri') !== false ? 'active' : '' ?>">Galeri</a></li>
                    <li><a href="<?= Router::url('/iletisim') ?>" class="<?= strpos($_SERVER['REQUEST_URI'], 'iletisim') !== false ? 'active' : '' ?>">İletişim</a></li>
                </ul>
            </nav>
            
            <!-- Header Right -->
            <div class="header-right">
                <a href="tel:<?= site('contact_phone', '02322771100') ?>" class="header-phone">
                    <i data-lucide="phone"></i>
                    <span><?= site('contact_phone_display', '0232 277 11 00') ?></span>
                </a>
                <a href="<?= Router::url('/teklif-al') ?>" class="btn btn-primary">Teklif Al</a>
                
                <!-- Mobile Menu Toggle -->
                <div class="mobile-menu-toggle" id="mobileMenuToggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main>
        <?= $content ?? '' ?>
    </main>
    
    <!-- Footer (Ported from V1 includes/footer.php) -->
    <footer class="site-footer">
        <div class="container">
            <div class="footer-grid">
                <!-- Brand Column -->
                <div class="footer-brand">
                    <a href="<?= Router::url('/') ?>" class="logo">
                        <div class="logo-icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="20" cy="20" r="18" stroke="#c9a74e" stroke-width="2" fill="none"/>
                                <path d="M12 20 L20 12 L28 20 L20 28 Z" stroke="#c9a74e" stroke-width="2" fill="none"/>
                                <circle cx="20" cy="20" r="4" stroke="#c9a74e" stroke-width="2" fill="none"/>
                            </svg>
                        </div>
                        <div class="logo-text">
                            YAPI<span>DEKORASYON</span>
                        </div>
                    </a>
                    <p>Profesyonel iç mekan tasarımı ve tadilat hizmetleri. Hayalinizdeki mekanı birlikte yaratıyoruz.</p>
                    <div class="footer-social">
                        <a href="<?= site('social_facebook', '#') ?>" aria-label="Facebook"><i data-lucide="facebook"></i></a>
                        <a href="<?= site('social_instagram', '#') ?>" aria-label="Instagram"><i data-lucide="instagram"></i></a>
                    </div>
                </div>
                
                <!-- Kurumsal Links -->
                <div class="footer-column">
                    <h4>Kurumsal</h4>
                    <ul class="footer-links">
                        <li><a href="<?= Router::url('/hakkimizda') ?>">Hakkımızda</a></li>
                        <li><a href="<?= Router::url('/referanslar') ?>">Referanslar</a></li>
                        <li><a href="<?= Router::url('/blog') ?>">Blog</a></li>
                        <li><a href="<?= Router::url('/iletisim') ?>">İletişim</a></li>
                    </ul>
                </div>
                
                <!-- Hizmetlerimiz Links -->
                <div class="footer-column">
                    <h4>Hizmetlerimiz</h4>
                    <ul class="footer-links">
                        <li><a href="<?= Router::serviceUrl('ic-mekan-tasarimi') ?>">İç Mekan Tasarımı</a></li>
                        <li><a href="<?= Router::serviceUrl('komple-tadilat') ?>">Komple Tadilat</a></li>
                        <li><a href="<?= Router::serviceUrl('mutfak-yenileme') ?>">Mutfak Yenileme</a></li>
                        <li><a href="<?= Router::serviceUrl('banyo-yenileme') ?>">Banyo Yenileme</a></li>
                        <li><a href="<?= Router::serviceUrl('laminat-parke') ?>">Laminat Parke</a></li>
                    </ul>
                </div>
                
                <!-- Contact Info -->
                <div class="footer-column">
                    <h4>Bize Ulaşın</h4>
                    <div class="footer-contact-item">
                        <i data-lucide="map-pin"></i>
                        <p><?= site('contact_address', 'İzmir, Türkiye') ?></p>
                    </div>
                    <div class="footer-contact-item">
                        <i data-lucide="phone"></i>
                        <p><?= site('contact_phone_display', '0536 277 17 09') ?></p>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <p>&copy; <?= date('Y') ?> Yapı Dekorasyon. Tüm hakları saklıdır.</p>
                <div class="footer-bottom-links">
                    <a href="<?= Router::url('/iletisim') ?>">Gizlilik Politikası</a>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- JavaScript -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/mcstudios/glightbox/dist/js/glightbox.min.js"></script>
    <script src="<?= Router::url('/assets/js/script.js') ?>"></script>
    <script>
        // Initialize Libraries
        lucide.createIcons();
        AOS.init({
            duration: 800,
            once: true,
            offset: 100
        });
    </script>
</body>
</html>
