<?php
/**
 * Footer Partial - SEO Optimized
 * Aegean Dominance - Yapı Dekorasyon V2
 * Domain Network entegrasyonu ile (Admin panelden yönetilen)
 */

$phone = site('contact_phone', SITE_PHONE);
$email = site('contact_email', SITE_EMAIL);
$address = site('contact_address', SITE_ADDRESS);
$whatsapp = site('contact_whatsapp', SITE_WHATSAPP);

// Get featured services via SiteSettings
$featuredServices = siteSettings()->getActiveServices(8);

// Get cities via SiteSettings
$cities = siteSettings()->getActiveCities();

// Domain Network - Admin panelden yönetilen SEO dofollow linkler
$domainNetwork = siteSettings()->getNetworkLinks();
?>

<!-- CTA Section -->
<section class="py-16 bg-gradient-to-r from-gold-dark via-gold to-gold-light">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-heading font-bold text-dark mb-4">
            Ücretsiz Keşif ve Teklif Alın
        </h2>
        <p class="text-dark/80 text-lg mb-8 max-w-2xl mx-auto">
            35 yıllık tecrübemizle projenize en uygun çözümü sunuyoruz. Hemen arayın, ücretsiz keşif ve teklif alın.
        </p>
        <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
            <a href="tel:<?= $phone ?>" class="flex items-center gap-2 bg-dark text-white px-8 py-4 rounded-lg font-bold hover:bg-dark-card transition-all">
                <i data-lucide="phone" class="w-5 h-5"></i>
                <?= $phone ?>
            </a>
            <a href="https://wa.me/<?= $whatsapp ?>" target="_blank" rel="noopener" class="flex items-center gap-2 bg-green-600 text-white px-8 py-4 rounded-lg font-bold hover:bg-green-700 transition-all">
                <i data-lucide="message-circle" class="w-5 h-5"></i>
                WhatsApp
            </a>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="bg-dark-card border-t border-dark-border">
    <div class="container mx-auto px-4 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-10">
            
            <!-- About -->
            <div class="lg:col-span-2">
                <a href="<?= Router::url('/') ?>" class="flex items-center gap-3 mb-6">
                    <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center">
                        <i data-lucide="umbrella" class="w-7 h-7 text-dark"></i>
                    </div>
                    <div>
                        <span class="block text-xl font-heading font-bold text-white"><?= SITE_NAME ?></span>
                        <span class="block text-xs text-gold"><?= SITE_SLOGAN ?></span>
                    </div>
                </a>
                <p class="text-gray-400 leading-relaxed mb-6">
                    1990'dan bu yana İzmir ve Ege Bölgesi'nde tadilat, dekorasyon, iç mimarlık ve anahtar teslim yenileme konusunda hizmet veriyoruz. 
                    2000+ proje, 1500+ mutlu müşteri.
                </p>
                <div class="flex items-center gap-4">
                    <a href="<?= setting('social_facebook', '#') ?>" target="_blank" rel="noopener" aria-label="Facebook" class="w-10 h-10 rounded-lg bg-dark flex items-center justify-center text-gray-400 hover:text-gold hover:bg-dark-border transition-all">
                        <i data-lucide="facebook" class="w-5 h-5"></i>
                    </a>
                    <a href="<?= setting('social_instagram', '#') ?>" target="_blank" rel="noopener" aria-label="Instagram" class="w-10 h-10 rounded-lg bg-dark flex items-center justify-center text-gray-400 hover:text-gold hover:bg-dark-border transition-all">
                        <i data-lucide="instagram" class="w-5 h-5"></i>
                    </a>
                    <a href="https://wa.me/<?= $whatsapp ?>" target="_blank" rel="noopener" aria-label="WhatsApp" class="w-10 h-10 rounded-lg bg-dark flex items-center justify-center text-gray-400 hover:text-green-500 hover:bg-dark-border transition-all">
                        <i data-lucide="message-circle" class="w-5 h-5"></i>
                    </a>
                </div>
            </div>
            
            <!-- Services -->
            <div>
                <h3 class="text-lg font-heading font-bold text-white mb-6">Hizmetlerimiz</h3>
                <ul class="space-y-3">
                    <?php foreach ($featuredServices as $service): ?>
                    <li>
                        <a href="<?= Router::serviceUrl($service['slug']) ?>" class="text-gray-400 hover:text-gold transition-colors">
                            <?= htmlspecialchars($service['name']) ?>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <!-- SEO: Hizmet Bölgelerimiz & Bağlantılar -->
            <div>
                <h3 class="text-lg font-heading font-bold text-white mb-6">Hizmet Bölgelerimiz</h3>
                <ul class="space-y-3">
                    <?php foreach ($cities as $city): ?>
                    <li>
                        <a href="<?= Router::cityUrl($city['slug']) ?>" class="text-gray-400 hover:text-gold transition-colors">
                            <?= htmlspecialchars($city['name']) ?> Tente
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
                
                <!-- Domain Network - SEO dofollow links -->
                <div class="mt-6 pt-4 border-t border-dark-border">
                    <span class="text-gold text-sm font-semibold block mb-3">
                        <i data-lucide="globe" class="w-4 h-4 inline mr-1"></i>
                        Tente.net Ağı
                    </span>
                    <ul class="space-y-2">
                        <?php foreach ($domainNetwork as $network): ?>
                        <li>
                            <a href="<?= htmlspecialchars($network['target_url'] ?? 'https://' . $network['domain']) ?>" 
                               target="_blank" 
                               rel="noopener<?= ($network['rel_attribute'] ?? 'dofollow') === 'nofollow' ? ' nofollow' : '' ?>"
                               title="<?= htmlspecialchars($network['title'] ?? $network['domain']) ?>"
                               class="text-gray-500 hover:text-gold transition-colors text-sm flex items-center gap-1">
                                <i data-lucide="external-link" class="w-3 h-3"></i>
                                <?= htmlspecialchars($network['anchor_text'] ?? $network['domain']) ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            
            <!-- Contact -->
            <div>
                <h3 class="text-lg font-heading font-bold text-white mb-6">İletişim</h3>
                <ul class="space-y-4">
                    <li class="flex items-start gap-3">
                        <i data-lucide="map-pin" class="w-5 h-5 text-gold flex-shrink-0 mt-1"></i>
                        <address class="text-gray-400 not-italic"><?= htmlspecialchars($address) ?></address>
                    </li>
                    <li>
                        <a href="tel:<?= $phone ?>" class="flex items-center gap-3 text-gray-400 hover:text-gold transition-colors">
                            <i data-lucide="phone" class="w-5 h-5 text-gold"></i>
                            <?= $phone ?>
                        </a>
                    </li>
                    <li>
                        <a href="mailto:<?= $email ?>" class="flex items-center gap-3 text-gray-400 hover:text-gold transition-colors">
                            <i data-lucide="mail" class="w-5 h-5 text-gold"></i>
                            <?= $email ?>
                        </a>
                    </li>
                    <li class="flex items-center gap-3">
                        <i data-lucide="clock" class="w-5 h-5 text-gold"></i>
                        <span class="text-gray-400">Pzt - Cmt: 09:00 - 18:00</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    
    <!-- Copyright & Links -->
    <div class="border-t border-dark-border">
        <div class="container mx-auto px-4 py-6">
            <div class="flex flex-col md:flex-row items-center justify-between gap-4 text-sm text-gray-500">
                <p>© <?= date('Y') ?> <?= SITE_NAME ?>. Tüm hakları saklıdır.</p>
                <div class="flex items-center gap-6">
                    <a href="<?= Router::url('/gizlilik-politikasi') ?>" class="hover:text-gold transition-colors">Gizlilik Politikası</a>
                    <a href="<?= Router::url('/kullanim-sartlari') ?>" class="hover:text-gold transition-colors">Kullanım Şartları</a>
                    <a href="<?= Router::url('/sitemap.xml') ?>" class="hover:text-gold transition-colors">Site Haritası</a>
                </div>
            </div>
        </div>
    </div>
</footer>
