<?php
/**
 * Header Partial
 * Aegean Dominance - Yapı Dekorasyon V2
 */

$phone = setting('contact_phone', SITE_PHONE);
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>

<!-- Top Bar -->
<div class="bg-dark-card border-b border-dark-border">
    <div class="container mx-auto px-4 py-2">
        <div class="flex items-center justify-between text-sm">
            <div class="flex items-center gap-6 text-gray-400">
                <a href="tel:<?= $phone ?>" class="flex items-center gap-2 hover:text-gold transition-colors">
                    <i data-lucide="phone" class="w-4 h-4"></i>
                    <span><?= $phone ?></span>
                </a>
                <span class="hidden md:flex items-center gap-2">
                    <i data-lucide="clock" class="w-4 h-4"></i>
                    <span>Pzt-Cmt: 09:00 - 18:00</span>
                </span>
            </div>
            <div class="flex items-center gap-4">
                <a href="<?= setting('social_facebook', '#') ?>" target="_blank" class="text-gray-400 hover:text-gold transition-colors">
                    <i data-lucide="facebook" class="w-4 h-4"></i>
                </a>
                <a href="<?= setting('social_instagram', '#') ?>" target="_blank" class="text-gray-400 hover:text-gold transition-colors">
                    <i data-lucide="instagram" class="w-4 h-4"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Main Header -->
<header class="sticky top-0 z-50 bg-dark/95 backdrop-blur-md border-b border-dark-border">
    <div class="container mx-auto px-4">
        <div class="flex items-center justify-between h-20">
            
            <!-- Logo -->
            <a href="<?= Router::url('/') ?>" class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-lg gradient-gold flex items-center justify-center">
                    <i data-lucide="umbrella" class="w-7 h-7 text-dark"></i>
                </div>
                <div>
                    <span class="block text-xl font-heading font-bold text-white"><?= SITE_NAME ?></span>
                    <span class="block text-xs text-gold"><?= SITE_SLOGAN ?></span>
                </div>
            </a>
            
            <!-- Desktop Navigation -->
            <nav class="hidden lg:flex items-center gap-8">
                <a href="<?= Router::url('/') ?>" class="text-gray-300 hover:text-gold transition-colors font-medium">
                    Ana Sayfa
                </a>
                <div class="relative group">
                    <a href="<?= Router::url('/hizmetlerimiz') ?>" class="flex items-center gap-1 text-gray-300 hover:text-gold transition-colors font-medium">
                        Hizmetlerimiz
                        <i data-lucide="chevron-down" class="w-4 h-4"></i>
                    </a>
                    <!-- Dropdown -->
                    <div class="absolute top-full left-0 w-64 bg-dark-card border border-dark-border rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 mt-2">
                        <div class="py-2">
                            <a href="<?= Router::serviceUrl('bioklimatik-pergola') ?>" class="block px-4 py-2 text-gray-300 hover:text-gold hover:bg-dark transition-colors">Bioklimatik Pergola</a>
                            <a href="<?= Router::serviceUrl('pergola-tente') ?>" class="block px-4 py-2 text-gray-300 hover:text-gold hover:bg-dark transition-colors">Pergola Tente</a>
                            <a href="<?= Router::serviceUrl('mafsalli-tente') ?>" class="block px-4 py-2 text-gray-300 hover:text-gold hover:bg-dark transition-colors">Mafsallı Tente</a>
                            <a href="<?= Router::serviceUrl('zip-perde') ?>" class="block px-4 py-2 text-gray-300 hover:text-gold hover:bg-dark transition-colors">Zip Perde</a>
                            <a href="<?= Router::serviceUrl('surgulu-cam-balkon') ?>" class="block px-4 py-2 text-gray-300 hover:text-gold hover:bg-dark transition-colors">Cam Balkon</a>
                            <div class="border-t border-dark-border my-2"></div>
                            <a href="<?= Router::url('/hizmetlerimiz') ?>" class="block px-4 py-2 text-gold hover:bg-dark transition-colors font-medium">Tümünü Gör →</a>
                        </div>
                    </div>
                </div>
                <a href="<?= Router::url('/galeri') ?>" class="text-gray-300 hover:text-gold transition-colors font-medium">
                    Galeri
                </a>
                <a href="<?= Router::url('/referanslar') ?>" class="text-gray-300 hover:text-gold transition-colors font-medium">
                    Referanslar
                </a>
                <a href="<?= Router::url('/hakkimizda') ?>" class="text-gray-300 hover:text-gold transition-colors font-medium">
                    Hakkımızda
                </a>
                <a href="<?= Router::url('/iletisim') ?>" class="text-gray-300 hover:text-gold transition-colors font-medium">
                    İletişim
                </a>
            </nav>
            
            <!-- CTA Button -->
            <div class="hidden lg:flex items-center gap-4">
                <a href="tel:<?= $phone ?>" class="flex items-center gap-2 text-gold hover:text-gold-light transition-colors">
                    <i data-lucide="phone" class="w-5 h-5"></i>
                    <span class="font-semibold"><?= $phone ?></span>
                </a>
                <a href="<?= Router::url('/teklif-al') ?>" class="btn-gold px-6 py-3 rounded-lg text-dark font-bold transition-all">
                    Hemen Teklif Al
                </a>
            </div>
            
            <!-- Mobile Menu Button -->
            <button id="mobileMenuBtn" class="lg:hidden p-2 text-gray-300 hover:text-gold transition-colors">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
        </div>
    </div>
    
    <!-- Mobile Menu -->
    <div id="mobileMenu" class="lg:hidden hidden bg-dark-card border-t border-dark-border">
        <nav class="container mx-auto px-4 py-4 space-y-4">
            <a href="<?= Router::url('/') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">Ana Sayfa</a>
            <a href="<?= Router::url('/hizmetlerimiz') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">Hizmetlerimiz</a>
            <a href="<?= Router::url('/galeri') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">Galeri</a>
            <a href="<?= Router::url('/referanslar') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">Referanslar</a>
            <a href="<?= Router::url('/hakkimizda') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">Hakkımızda</a>
            <a href="<?= Router::url('/iletisim') ?>" class="block text-gray-300 hover:text-gold transition-colors py-2">İletişim</a>
            <a href="<?= Router::url('/teklif-al') ?>" class="block btn-gold text-center px-6 py-3 rounded-lg text-dark font-bold mt-4">Hemen Teklif Al</a>
        </nav>
    </div>
</header>

<script>
    document.getElementById('mobileMenuBtn').addEventListener('click', function() {
        document.getElementById('mobileMenu').classList.toggle('hidden');
    });
</script>
