<?php
/**
 * Teklif Al Sayfası
 * İzmir Tenteci V2
 */

$pageTitle = 'Ücretsiz Teklif Al | İzmir Tenteci';
$pageDescription = 'Tente, pergola ve cam balkon sistemleri için ücretsiz keşif ve fiyat teklifi alın.';

$phone = setting('contact_phone', SITE_PHONE);
$whatsapp = setting('contact_whatsapp', SITE_WHATSAPP);

// Hizmetleri al
$services = db()->fetchAll("SELECT id, name FROM services WHERE is_active = 1 ORDER BY display_order");

// Form gönderimi
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $phoneInput = trim($_POST['phone'] ?? '');
    $emailInput = trim($_POST['email'] ?? '');
    $serviceType = trim($_POST['service_type'] ?? '');
    $message = trim($_POST['message'] ?? '');
    
    if (empty($name) || empty($phoneInput)) {
        $error = 'Lütfen adınızı ve telefon numaranızı girin.';
    } else {
        db()->execute(
            "INSERT INTO contact_forms (form_type, name, phone, email, service_type, message, ip_address) VALUES (?, ?, ?, ?, ?, ?, ?)",
            ['quote', $name, $phoneInput, $emailInput, $serviceType, $message, $_SERVER['REMOTE_ADDR'] ?? '']
        );
        $success = true;
    }
}

ob_start();
?>

<!-- Hero -->
<section class="py-20 bg-gradient-to-b from-dark-card to-dark">
    <div class="container mx-auto px-4 text-center">
        <span class="inline-block text-gold text-sm font-semibold tracking-wider uppercase mb-4">ÜCRETSİZ TEKLİF</span>
        <h1 class="text-4xl md:text-5xl font-heading font-bold text-white mb-6">
            Hemen Teklif Alın
        </h1>
        <p class="text-xl text-gray-400 max-w-3xl mx-auto">
            Formu doldurun, 24 saat içinde size dönüş yapalım. Ücretsiz keşif ve fiyat teklifi.
        </p>
    </div>
</section>

<!-- Form Section -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            
            <!-- Hızlı İletişim -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-12">
                <a href="tel:<?= $phone ?>" class="flex items-center gap-4 p-6 card-dark rounded-xl hover:border-gold/30 transition-all">
                    <div class="w-14 h-14 rounded-xl gradient-gold flex items-center justify-center">
                        <i data-lucide="phone" class="w-7 h-7 text-dark"></i>
                    </div>
                    <div>
                        <div class="text-gray-400 text-sm">Hemen Ara</div>
                        <div class="text-gold text-xl font-bold"><?= $phone ?></div>
                    </div>
                </a>
                
                <a href="https://wa.me/<?= $whatsapp ?>" target="_blank" class="flex items-center gap-4 p-6 card-dark rounded-xl hover:border-green-500/30 transition-all">
                    <div class="w-14 h-14 rounded-xl bg-green-500 flex items-center justify-center">
                        <i data-lucide="message-circle" class="w-7 h-7 text-white"></i>
                    </div>
                    <div>
                        <div class="text-gray-400 text-sm">WhatsApp</div>
                        <div class="text-green-400 text-xl font-bold">Mesaj Gönder</div>
                    </div>
                </a>
            </div>
            
            <!-- Form -->
            <div class="card-dark rounded-2xl p-8">
                <h2 class="text-2xl font-heading font-bold text-white mb-6 text-center">Teklif Formu</h2>
                
                <?php if ($success): ?>
                <div class="bg-green-500/10 border border-green-500/30 text-green-400 rounded-lg p-6 text-center mb-6">
                    <i data-lucide="check-circle" class="w-12 h-12 mx-auto mb-4"></i>
                    <div class="text-xl font-bold mb-2">Talebiniz Alındı!</div>
                    <p>En kısa sürede size dönüş yapacağız.</p>
                </div>
                <?php else: ?>
                
                <?php if ($error): ?>
                <div class="bg-red-500/10 border border-red-500/30 text-red-400 rounded-lg p-4 mb-6">
                    <i data-lucide="alert-circle" class="w-5 h-5 inline mr-2"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
                <?php endif; ?>
                
                <form method="POST" class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-gray-400 mb-2">Adınız Soyadınız *</label>
                            <input type="text" name="name" required
                                   class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                                   placeholder="Adınız Soyadınız">
                        </div>
                        
                        <div>
                            <label class="block text-gray-400 mb-2">Telefon *</label>
                            <input type="tel" name="phone" required
                                   class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                                   placeholder="05XX XXX XX XX">
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-gray-400 mb-2">E-posta</label>
                            <input type="email" name="email"
                                   class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors"
                                   placeholder="ornek@email.com">
                        </div>
                        
                        <div>
                            <label class="block text-gray-400 mb-2">İlgilendiğiniz Ürün</label>
                            <select name="service_type"
                                    class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors">
                                <option value="">Seçiniz...</option>
                                <?php foreach ($services as $service): ?>
                                <option value="<?= htmlspecialchars($service['name']) ?>"><?= htmlspecialchars($service['name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-gray-400 mb-2">Notunuz</label>
                        <textarea name="message" rows="4"
                                  class="w-full bg-dark border border-dark-border rounded-lg px-4 py-3 text-white focus:border-gold focus:outline-none transition-colors resize-none"
                                  placeholder="Proje detaylarınız, ölçüler, özel istekleriniz..."></textarea>
                    </div>
                    
                    <button type="submit" class="w-full btn-gold py-4 rounded-lg text-dark font-bold flex items-center justify-center gap-2 text-lg">
                        <i data-lucide="send" class="w-5 h-5"></i>
                        Ücretsiz Teklif Al
                    </button>
                    
                    <p class="text-center text-gray-500 text-sm">
                        * Bilgileriniz gizli tutulacak ve 3. şahıslarla paylaşılmayacaktır.
                    </p>
                </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
