<?php
/**
 * Referanslar Sayfası
 * Yapı Dekorasyon V2
 */

$pageTitle = 'Referanslar | Yapı Dekorasyon';
$pageDescription = 'Mutlu müşterilerimizin yorumları. 2000+ proje, 1500+ mutlu müşteri.';

// Testimonials
$testimonials = db()->fetchAll(
    "SELECT * FROM testimonials WHERE is_active = 1 ORDER BY display_order"
);

ob_start();
?>

<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <div class="hero-breadcrumb">
            <a href="<?= Router::url('/') ?>">Ana Sayfa</a>
            <i data-lucide="chevron-right"></i>
            <span class="text-white">Referanslar</span>
        </div>
        
        <div class="hero-badge">Sizden Gelenler</div>
        <h1>Müşterilerimiz Ne Diyor?</h1>
        <p class="lead">35 yılda 2000+ proje, 1500+ mutlu müşteri. İşte onların yorumları ve deneyimleri.</p>
    </div>
</section>

<!-- Stats Strip -->
<div class="stats-strip">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-box">
                <div class="number">2000+</div>
                <div class="label">Tamamlanan Proje</div>
            </div>
             <div class="stat-box">
                <div class="number">1500+</div>
                <div class="label">Mutlu Müşteri</div>
            </div>
             <div class="stat-box">
                <div class="number">35</div>
                <div class="label">Yıllık Tecrübe</div>
            </div>
             <div class="stat-box">
                <div class="number">4.9</div>
                <div class="label">Ortalama Puan</div>
            </div>
        </div>
    </div>
</div>

<!-- Testimonials Grid -->
<section class="section-padding bg-dark">
    <div class="container">
        <div class="testimonials-grid">
             <?php foreach ($testimonials as $testimonial): ?>
            <div class="testimonial-card">
                <div class="rating-stars">
                    <?php for ($i = 0; $i < ($testimonial['rating'] ?? 5); $i++): ?>
                    <i data-lucide="star" style="width: 16px; height: 16px; fill: currentColor;"></i>
                    <?php endfor; ?>
                </div>
                
                <p class="quote-text">
                    "<?= htmlspecialchars($testimonial['content']) ?>"
                </p>
                
                <div class="author-info">
                    <div class="author-avatar">
                        <?= mb_substr($testimonial['customer_name'], 0, 1) ?>
                    </div>
                    <div class="author-details">
                        <div><?= htmlspecialchars($testimonial['customer_name']) ?></div>
                        <div><?= htmlspecialchars($testimonial['customer_location'] ?? 'İzmir') ?></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="cta-banner">
    <div class="container">
        <div class="cta-content-box">
            <div class="cta-text">
                <h2>Siz de Mutlu Müşterilerimiz Arasına Katılın</h2>
                <p>Ücretsiz keşif ve fiyat teklifi için hemen arayın.</p>
            </div>
            <div class="cta-actions">
                <a href="<?= Router::url('/teklif-al') ?>" class="btn btn-white">
                    <i data-lucide="calculator"></i> Ücretsiz Teklif Al
                </a>
            </div>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
