<?php
/**
 * Service Detail Page - Premium Layout
 * Yapı Dekorasyon V2
 */

$slug = $router->getParam('slug');

// Fetch Service Data
$service = db()->fetchOne(
    "SELECT * FROM services WHERE slug = ? AND is_active = 1",
    [$slug]
);

if (!$service) {
    $router->render404();
    return;
}

// Fetch Images
try {
    $images = db()->fetchAll(
        "SELECT * FROM service_images WHERE service_id = ? ORDER BY is_featured DESC, display_order",
        [$service['id']]
    );
} catch (Exception $e) { $images = []; }

// Fetch Related Services
try {
    $relatedServices = db()->fetchAll(
        "SELECT * FROM services WHERE category = ? AND id != ? AND is_active = 1 ORDER BY display_order LIMIT 3",
        [$service['category'] ?? '', $service['id']]
    );
} catch (Exception $e) { $relatedServices = []; }

// Metadata & SEO
$pageTitle = $service['name'] . ' | Yapı Dekorasyon';
$pageDescription = $service['short_description'] ?? 'İzmir profesyonel tadilat hizmetleri.';

// SEO Configuration
$seoPageType = 'service';
$seoPageData = [
    'name' => $service['name'],
    'slug' => $service['slug'],
    'category' => $service['category'] ?? 'Hizmet',
    'short_description' => $service['short_description'] ?? '',
    'description' => $service['description'] ?? '',
    'featured_image' => !empty($images) ? '/' . $images[0]['image_path'] : '/assets/images/hero-bg.jpg'
];

ob_start();
?>

<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <!-- Breadcrumb -->
        <nav class="hero-breadcrumb">
            <a href="<?= Router::url('/') ?>">Ana Sayfa</a>
            <i data-lucide="chevron-right" style="width: 14px;"></i>
            <a href="<?= Router::url('/hizmetlerimiz') ?>">Hizmetlerimiz</a>
            <i data-lucide="chevron-right" style="width: 14px;"></i>
            <span class="text-white"><?= htmlspecialchars($service['name']) ?></span>
        </nav>

        <div class="hero-badge">
            <span style="width: 8px; height: 8px; background: #c9a74e; border-radius: 50%;"></span>
            <?= htmlspecialchars($service['category'] ?? 'Hizmet') ?>
        </div>
        
        <h1><?= htmlspecialchars($service['name']) ?></h1>
        <p class="lead">
            <?= htmlspecialchars($service['short_description'] ?? 'Profesyonel çözümler ve üstün işçilik.') ?>
        </p>
    </div>
</section>

<!-- Main Content -->
<section class="service-detail-section">
    <div class="container">
        <div class="detail-layout">
            
            <!-- LEFT COLUMN: Content -->
            <div class="detail-content">
                
                <!-- Gallery -->
                <div class="product-gallery">
                    <?php if (!empty($images)): ?>
                    <img src="<?= Router::url('/' . $images[0]['image_path']) ?>" 
                         alt="<?= htmlspecialchars($service['name']) ?>" 
                         class="product-main-img">
                    <?php else: ?>
                    <div class="product-main-img" style="background: #eee; display: flex; align-items: center; justify-content: center; color: #ccc;">
                        <i data-lucide="image" style="width: 64px; height: 64px;"></i>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Tabs -->
                <div class="tabs-nav">
                    <button class="tab-btn active">Genel Bakış</button>
                    <button class="tab-btn">Teknik Detaylar</button>
                    <button class="tab-btn">Sıkça Sorulanlar</button>
                </div>

                <!-- Content Body -->
                <div class="content-body">
                    <?= $service['description'] ?>
                    
                    <h3>Neden Bu Hizmeti Seçmelisiniz?</h3>
                    <div class="feature-box-grid">
                        <div class="feature-box">
                            <div class="feature-box-icon">
                                <i data-lucide="shield-check"></i>
                            </div>
                            <div>
                                <h4>Garantili İşçilik</h4>
                                <p>Tüm uygulamalarımız 2 yıl firmamız garantisi altındadır.</p>
                            </div>
                        </div>
                        <div class="feature-box">
                            <div class="feature-box-icon">
                                <i data-lucide="clock"></i>
                            </div>
                            <div>
                                <h4>Zamanında Teslim</h4>
                                <p>Belirlenen iş programına %100 sadık kalıyoruz.</p>
                            </div>
                        </div>
                        <div class="feature-box">
                            <div class="feature-box-icon">
                                <i data-lucide="gem"></i>
                            </div>
                            <div>
                                <h4>Premium Malzeme</h4>
                                <p>Sadece 1. sınıf, TSE ve CE belgeli malzemeler kullanıyoruz.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- RIGHT COLUMN: Sidebar -->
            <div class="detail-sidebar">
                
                <!-- Quick Contact -->
                <div class="sidebar-widget">
                    <h3 class="widget-title">Hızlı Teklif Al</h3>
                    <form action="<?= Router::url('/teklif-gonder') ?>" method="POST">
                         <input type="hidden" name="service_id" value="<?= $service['id'] ?>">
                        <div class="form-group">
                            <input type="text" name="name" class="form-control" placeholder="Adınız Soyadınız" required>
                        </div>
                        <div class="form-group">
                            <input type="tel" name="phone" class="form-control" placeholder="Telefon Numaranız" required>
                        </div>
                        <button type="submit" class="btn btn-gold" style="width: 100%; justify-content: center;">
                            <i data-lucide="send"></i> Gönder
                        </button>
                        <p style="font-size: 0.8rem; color: #999; margin-top: 10px; text-align: center;">
                            * Uzmanlarımız 15 dk içinde dönüş yapacaktır.
                        </p>
                    </form>
                </div>

                <!-- Features/Info Widget -->
                <div class="sidebar-widget">
                    <h3 class="widget-title">Hizmet Detayları</h3>
                    <div class="spec-list">
                        <div class="spec-item">
                            <span class="spec-label">Başlangıç:</span>
                            <span class="spec-value">Keşif Sonrası</span>
                        </div>
                        <div class="spec-item">
                            <span class="spec-label">Süre:</span>
                            <span class="spec-value">Proje Bazlı</span>
                        </div>
                         <div class="spec-item">
                            <span class="spec-label">Keşif:</span>
                            <span class="spec-value" style="color: var(--primary);">Ücretsiz</span>
                        </div>
                        <div class="spec-item">
                            <span class="spec-label">Bölge:</span>
                            <span class="spec-value">Tüm Ege</span>
                        </div>
                    </div>
                </div>

                <!-- Guarantee Badge -->
                <div class="guarantee-badge">
                    <i data-lucide="award" class="guarantee-icon"></i>
                    <div class="guarantee-text">
                        <div>%100</div>
                        <div>Müşteri Memnuniyeti<br>Garantisi</div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- Related Services (Footer-like) -->
<?php if (!empty($relatedServices)): ?>
<section class="section-padding bg-light">
    <div class="container">
        <h3 style="margin-bottom: 2rem;">İlginizi Çekebilecek Diğer Hizmetler</h3>
        <div class="services-wrapper">
            <?php foreach ($relatedServices as $related): ?>
            <a href="<?= Router::serviceUrl($related['slug']) ?>" class="service-box">
                <div class="service-icon" style="width: 48px; height: 48px; margin-bottom: 1rem;">
                    <i data-lucide="<?= $related['icon'] ?? 'plus' ?>"></i>
                </div>
                <h4 style="font-size: 1.1rem; margin-bottom: 0.5rem;"><?= htmlspecialchars($related['name']) ?></h4>
                <div class="service-link" style="font-size: 0.85rem;">İncele <i data-lucide="arrow-right" style="width: 14px;"></i></div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
