<?php
/**
 * Hizmetler Sayfası
 * Yapı Dekorasyon V2
 */

$pageTitle = 'Hizmetlerimiz | Yapı Dekorasyon';
$pageDescription = 'Tadilat, dekorasyon, iç mimarlık ve anahtar teslim yenileme hizmetlerimiz. Profesyonel çözümler.';

// Tüm hizmetleri çek
$services = db()->fetchAll(
    "SELECT * FROM services WHERE is_active = 1 ORDER BY display_order"
);

// Kategorilere göre grupla
$categories = [];
foreach ($services as $service) {
    $cat = $service['category'] ?? 'Diğer';
    if (!isset($categories[$cat])) {
        $categories[$cat] = [];
    }
    $categories[$cat][] = $service;
}

ob_start();
?>

<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <div class="hero-breadcrumb">
            <a href="<?= Router::url('/') ?>">Ana Sayfa</a>
            <i data-lucide="chevron-right"></i>
            <span class="text-white">Hizmetlerimiz</span>
        </div>
        
        <div class="hero-badge">Profesyonel Çözümler</div>
        <h1>Hizmetlerimiz</h1>
        <p class="lead">35 yıllık tecrübemizle İzmir ve Ege Bölgesi'nde anahtar teslim tadilat, dekorasyon ve mimari tasarım hizmetleri sunuyoruz.</p>
    </div>
</section>

<!-- Services List -->
<?php foreach ($categories as $categoryName => $categoryServices): ?>
<section class="section-padding services-section">
    <div class="container">
        <div class="section-header" style="margin-bottom: 3rem;">
            <span class="sub-heading">KATEGORİ</span>
            <h2 style="font-size: 2.5rem;"><?= htmlspecialchars($categoryName) ?> Çözümleri</h2>
        </div>
        
        <div class="services-wrapper">
            <?php foreach ($categoryServices as $service): ?>
            <a href="<?= Router::serviceUrl($service['slug']) ?>" class="service-box">
                <div class="service-icon">
                    <i data-lucide="<?= $service['icon'] ?? 'settings' ?>"></i>
                </div>
                <h3><?= htmlspecialchars($service['name']) ?></h3>
                <p><?= htmlspecialchars($service['short_description'] ?? 'Detaylı bilgi için tıklayınız.') ?></p>
                <span class="service-link">
                    İncele <i data-lucide="arrow-right" style="width: 16px;"></i>
                </span>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endforeach; ?>

<!-- CTA Banner -->
<section class="cta-banner">
    <div class="container">
        <div class="cta-content-box">
            <div class="cta-text">
                <h2>Hayalinizdeki Mekanı Yaratın</h2>
                <p>Ücretsiz keşif ve mimari danışmanlık hizmetimizden yararlanın.</p>
            </div>
            <div class="cta-actions">
                <a href="<?= Router::url('/teklif-al') ?>" class="btn btn-white">
                    <i data-lucide="clipboard-list"></i> Teklif Al
                </a>
                <a href="tel:<?= setting('contact_phone', SITE_PHONE) ?>" class="btn btn-outline-dark" style="border-color: #fff; color: #fff;">
                    <i data-lucide="phone"></i> Bizi Arayın
                </a>
            </div>
        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include VIEWS_PATH . '/layout.php';
?>
